#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: feed
version: 1.0.0.0
id: feed-1.0.0.0-1gpZNkud2jOCacbGCVWN2i
key: feed-1.0.0.0-1gpZNkud2jOCacbGCVWN2i
license: BSD3
maintainer: Adam Bergmark <adam@bergmark.nl>
homepage: https://github.com/bergmark/feed
synopsis: Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.
description:
    Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.
    .
    To help working with the multiple feed formats we'\''ve
    ended up with, this set of modules provides parsers,
    pretty printers and some utility code for querying
    and just generally working with a concrete representation
    of feeds in Haskell.
    .
    See here for an example of how to create an Atom feed:
    <https://github.com/bergmark/feed/blob/master/tests/Example/CreateAtom.hs>
    .
    For basic reading and editing of feeds, consult
    the documentation of the Text.Feed.* hierarchy.
category: Text
author: Sigbjorn Finne <sof@forkIO.com>
exposed: True
indefinite: False
exposed-modules:
    Text.Atom.Feed Text.Atom.Feed.Export Text.Atom.Feed.Import
    Text.Atom.Feed.Link Text.Atom.Feed.Validate Text.Atom.Pub
    Text.Atom.Pub.Export Text.DublinCore.Types Text.Feed.Constructor
    Text.Feed.Export Text.Feed.Import Text.Feed.Query
    Text.Feed.Translate Text.Feed.Types Text.Feed.Util Text.RSS.Export
    Text.RSS.Import Text.RSS.Syntax Text.RSS1.Export Text.RSS1.Import
    Text.RSS1.Syntax Text.RSS1.Utils
hidden-modules: Data.Text.Util Data.XML.Compat
abi: 7a6adcf025de92d42f75e2c79608801e
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/feed-1.0.0.0
library-dirs: /usr/lib/ghc-8.2.1/site-local/feed-1.0.0.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/haskell-feed
hs-libraries: HSfeed-1.0.0.0-1gpZNkud2jOCacbGCVWN2i
depends:
    base-4.10.0.0 base-compat-0.9.3-7gxrulAnYCf9OVK5Ok3lMW
    bytestring-0.10.8.2 old-locale-1.0.0.7-1sqf81TERjR1yVX7sI2OtM
    old-time-1.1.0.3-JBqRS8v7R0IBEIYolASC7h
    safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz time-1.8.0.2
    time-locale-compat-0.1.1.3-7E64RB3bIEXLKIO2d5DlHe
    utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m
    xml-types-0.3.6-JMA6F2EZctJ1CgZnvNtSRm
    xml-conduit-1.7.0-IwZsPRLvd5qEuqVqHgrmPJ
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             base-compat-0.9.3-7gxrulAnYCf9OVK5Ok3lMW=99c1023c304a14d4b5f863c8a16db1e9
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             old-locale-1.0.0.7-1sqf81TERjR1yVX7sI2OtM=bb3d8fbe7de4d3cc9ed854226de736b7
             old-time-1.1.0.3-JBqRS8v7R0IBEIYolASC7h=e36378d40a60df0fd2f08fb5571aec27
             safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5=6cf1fe7158a61976010b5254caed2ddd
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             time-locale-compat-0.1.1.3-7E64RB3bIEXLKIO2d5DlHe=69fe18ac914e2774b7e3fc94bb6244ef
             utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m=8d643a529d99a952051170bc6a18d0f2
             xml-types-0.3.6-JMA6F2EZctJ1CgZnvNtSRm=58a25c3831913db6d5817f7738b523a3
             xml-conduit-1.7.0-IwZsPRLvd5qEuqVqHgrmPJ=a9335b13a8c136c028def553e90bb77b
haddock-interfaces: /usr/share/doc/haskell-feed/html/feed.haddock
haddock-html: /usr/share/doc/haskell-feed/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

