#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger-lib
version: 1.4
id: hledger-lib-1.4-7YBDA3gWktN4EruFlTy1CJ
key: hledger-lib-1.4-7YBDA3gWktN4EruFlTy1CJ
license: GPL-3
maintainer: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Core data types, parsers and functionality for the hledger accounting tools
description:
    This is a reusable library containing hledger'\''s core functionality.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance
author: Simon Michael <simon@joyful.com>
exposed: True
indefinite: False
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.AutoTransaction
    Hledger.Data.Commodity Hledger.Data.Dates Hledger.Data.Journal
    Hledger.Data.Ledger Hledger.Data.MarketPrice Hledger.Data.Period
    Hledger.Data.Posting Hledger.Data.RawOptions
    Hledger.Data.StringFormat Hledger.Data.Timeclock
    Hledger.Data.Transaction Hledger.Data.Types Hledger.Query
    Hledger.Read Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.JournalReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.BalanceHistoryReport Hledger.Reports.BalanceReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReports
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.TransactionsReports Hledger.Utils
    Hledger.Utils.Color Hledger.Utils.Debug Hledger.Utils.Parse
    Hledger.Utils.Regex Hledger.Utils.String Hledger.Utils.Test
    Hledger.Utils.Text Hledger.Utils.Tree Hledger.Utils.UTF8IOCompat
    Text.Megaparsec.Compat
hidden-modules: Paths_hledger_lib
abi: c4b7a8ec16db3f0b4a08a086c4aa5432
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/hledger-lib-1.4
library-dirs: /usr/lib/ghc-8.2.1/site-local/hledger-lib-1.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/hledger-lib-1.4
hs-libraries: HShledger-lib-1.4-7YBDA3gWktN4EruFlTy1CJ
depends:
    base-4.10.0.0 base-compat-0.9.3-7gxrulAnYCf9OVK5Ok3lMW
    ansi-terminal-0.6.3.1-BIEgiaci8VQ7yyITu4jhfU array-0.5.2.0
    blaze-markup-0.8.0.0-FzqDX3sF5iY7olwigbNHfL bytestring-0.10.8.2
    cmdargs-0.10.18-FddQmgeT9xb4xNYVbmZNzf containers-0.5.10.2
    csv-0.1.2-FTLnfLeG7H17CWj1kGbhS5
    data-default-0.7.1.1-7D2kYbZAPZs3NL2w6K0r5J
    Decimal-0.4.2-EWS1i0hYG2ZCXaUNFpQloK deepseq-1.4.3.0
    directory-1.3.0.2 filepath-1.4.1.2
    hashtables-1.2.2.1-3p6lAWZsYRPKXmm9OSTcTo
    megaparsec-6.2.0-1CCDdQdqIjz5Mdr43Uee3l
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    old-time-1.1.0.3-JBqRS8v7R0IBEIYolASC7h
    parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh
    pretty-show-1.6.13-1Y3SqFKPaj5ELeEKE7rREK
    regex-tdfa-1.2.2-1G5AA2OVGrl1AkVWQSHaiw
    safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5
    semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP
    split-0.2.3.2-89BHvn20PlL73pGr1SBIHj
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz time-1.8.0.2
    transformers-0.5.2.0 uglymemo-0.1.0.1-BeMcvoCyAMhFrcpTqRc10L
    utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m
    HUnit-1.6.0.0-32Hmh42Ovy04fXZEjkNwW3
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             base-compat-0.9.3-7gxrulAnYCf9OVK5Ok3lMW=99c1023c304a14d4b5f863c8a16db1e9
             ansi-terminal-0.6.3.1-BIEgiaci8VQ7yyITu4jhfU=8d42c7012ae6bb1dfca5905fe8a25762
             array-0.5.2.0=5abf025fb7bf60079ec1f42bab285152
             blaze-markup-0.8.0.0-FzqDX3sF5iY7olwigbNHfL=8112a13be358d1f890474077a94c9c8e
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             cmdargs-0.10.18-FddQmgeT9xb4xNYVbmZNzf=ae2d362734d28c623f00890866ffdf43
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             csv-0.1.2-FTLnfLeG7H17CWj1kGbhS5=2b26144b3cdd6320c90851f81d71726c
             data-default-0.7.1.1-7D2kYbZAPZs3NL2w6K0r5J=51023526c672e559ef5f8b366e37519b
             Decimal-0.4.2-EWS1i0hYG2ZCXaUNFpQloK=e76a7a1a5c676aac1ee6e65bbb0e7bae
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             hashtables-1.2.2.1-3p6lAWZsYRPKXmm9OSTcTo=929ccc6d2bc72ec170fd815de36aecdf
             megaparsec-6.2.0-1CCDdQdqIjz5Mdr43Uee3l=fbe31c37b00724180a4a2e3202f474dd
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             old-time-1.1.0.3-JBqRS8v7R0IBEIYolASC7h=e36378d40a60df0fd2f08fb5571aec27
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             pretty-show-1.6.13-1Y3SqFKPaj5ELeEKE7rREK=87b44348ec83a99a6bb6345f11ac2835
             regex-tdfa-1.2.2-1G5AA2OVGrl1AkVWQSHaiw=a50652c6ce72d1a607b5e2d5892b65bc
             safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5=6cf1fe7158a61976010b5254caed2ddd
             semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP=7bc502c1773a3f628e3db58cb706740b
             split-0.2.3.2-89BHvn20PlL73pGr1SBIHj=c51f43c3e91d41531ae5282d108271a0
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             uglymemo-0.1.0.1-BeMcvoCyAMhFrcpTqRc10L=31d380439094c922a6cae4db72ff8493
             utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m=8d643a529d99a952051170bc6a18d0f2
             HUnit-1.6.0.0-32Hmh42Ovy04fXZEjkNwW3=403e14f0201c382f502c00d4ca640d0c
haddock-interfaces: /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html: /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

