#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: HTTP
version: 4000.3.8
id: HTTP-4000.3.8-LKMLTzyItoYFUdb1n18ptV
key: HTTP-4000.3.8-LKMLTzyItoYFUdb1n18ptV
license: BSD3
maintainer: Ganesh Sittampalam <ganesh@earth.li>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
    .
    __Note:__ This package does not support HTTPS connections.
    If you need HTTPS, take a look at the following packages:
    .
    * <http://hackage.haskell.org/package/http-streams http-streams>
    .
    * <http://hackage.haskell.org/package/http-client http-client> (in combination with
    <http://hackage.haskell.org/package/http-client-tls http-client-tls>)
    .
    * <http://hackage.haskell.org/package/req req>
    .
    * <http://hackage.haskell.org/package/wreq wreq>
    .
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
indefinite: False
exposed-modules:
    Network.Browser Network.BufferType Network.HTTP Network.HTTP.Auth
    Network.HTTP.Base Network.HTTP.Cookie Network.HTTP.HandleStream
    Network.HTTP.Headers Network.HTTP.Proxy Network.HTTP.Stream
    Network.Stream Network.StreamDebugger Network.StreamSocket
    Network.TCP
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
abi: ad16a0554ab273a5de2536f4ea3143c2
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/HTTP-4000.3.8
library-dirs: /usr/lib/ghc-8.2.1/site-local/HTTP-4000.3.8
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/HTTP-4000.3.8
hs-libraries: HSHTTP-4000.3.8-LKMLTzyItoYFUdb1n18ptV
depends:
    base-4.10.0.0 parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh array-0.5.2.0
    bytestring-0.10.8.2 time-1.8.0.2 mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK
    network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             array-0.5.2.0=5abf025fb7bf60079ec1f42bab285152
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             network-uri-2.6.1.0-4GXMsZ4PWr49y3TK4YgSYK=83774d660ce535b1c7a882f242c5fec6
             network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx=ef2cd2ee3956583f4f4dc001b18e6763
haddock-interfaces: /usr/share/doc/haskell-http/html/HTTP.haddock
haddock-html: /usr/share/doc/haskell-http/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

