#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: http-media
version: 0.7.1.1
id: http-media-0.7.1.1-IC7MqceKb34KNoeHVAAhLt
key: http-media-0.7.1.1-IC7MqceKb34KNoeHVAAhLt
license: MIT
copyright: (c) 2012-2017 Timothy Jones
maintainer: Timothy Jones <tim@zmthy.net>
homepage: https://github.com/zmthy/http-media
synopsis: Processing HTTP Content-Type and Accept headers
description:
    This library is intended to be a comprehensive solution to parsing and
    selecting quality-indexed values in HTTP headers.  It is capable of
    parsing both media types and language parameters from the Accept and
    Content header families, and can be extended to match against other
    accept headers as well.  Selecting the appropriate header value is
    achieved by comparing a list of server options against the
    quality-indexed values supplied by the client.
    .
    In the following example, the Accept header is parsed and then matched
    against a list of server options to serve the appropriate media using
    '\''mapAcceptMedia'\'':
    .
    > getHeader >>= maybe send406Error sendResourceWith . mapAcceptMedia
    >     [ ("text/html",        asHtml)
    >     , ("application/json", asJson)
    >     ]
    .
    Similarly, the Content-Type header can be used to produce a parser for
    request bodies based on the given content type with '\''mapContentMedia'\'':
    .
    > getContentType >>= maybe send415Error readRequestBodyWith . mapContentMedia
    >     [ ("application/json", parseJson)
    >     , ("text/plain",       parseText)
    >     ]
    .
    The API is agnostic to your choice of server.
category: Web
author: Timothy Jones
exposed: True
indefinite: False
exposed-modules:
    Network.HTTP.Media Network.HTTP.Media.Accept
    Network.HTTP.Media.Language Network.HTTP.Media.MediaType
    Network.HTTP.Media.RenderHeader
hidden-modules: Network.HTTP.Media.Language.Internal
                Network.HTTP.Media.MediaType.Internal Network.HTTP.Media.Quality
                Network.HTTP.Media.Utils
abi: 60ff141d676b2769879ffe4ea1f1c53b
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/http-media-0.7.1.1
library-dirs: /usr/lib/ghc-8.2.1/site-local/http-media-0.7.1.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/http-media-0.7.1.1
hs-libraries: HShttp-media-0.7.1.1-IC7MqceKb34KNoeHVAAhLt
depends:
    base-4.10.0.0 bytestring-0.10.8.2
    case-insensitive-1.2.0.10-G6p6xuzQuZQOyTREOVUmI containers-0.5.10.2
    utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             case-insensitive-1.2.0.10-G6p6xuzQuZQOyTREOVUmI=f9fb05439242cab6e496c322f2a1e33a
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m=8d643a529d99a952051170bc6a18d0f2
haddock-interfaces: /usr/share/doc/haskell-http-media/html/http-media.haddock
haddock-html: /usr/share/doc/haskell-http-media/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

