#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: QuickCheck
version: 2.10.1
id: QuickCheck-2.10.1-KIwpOgIMAPpCfx99HppzCX
key: QuickCheck-2.10.1-KIwpOgIMAPpCfx99HppzCX
license: BSD3
copyright: 2000-2017 Koen Claessen, 2006-2008 Björn Bringert, 2009-2017 Nick Smallbone
maintainer: Nick Smallbone <nick@smallbone.se>; see also QuickCheck mailing list (https://groups.google.com/forum/#!forum/haskell-quickcheck)
homepage: https://github.com/nick8325/quickcheck
synopsis: Automatic testing of Haskell programs
description:
    QuickCheck is a library for random testing of program properties.
    .
    The programmer provides a specification of the program, in the form of
    properties which functions should satisfy, and QuickCheck then tests that the
    properties hold in a large number of randomly generated cases.
    .
    Specifications are expressed in Haskell, using combinators defined in the
    QuickCheck library. QuickCheck provides combinators to define properties,
    observe the distribution of test data, and define test data generators.
    .
    The <http://www.cse.chalmers.se/~rjmh/QuickCheck/manual.html official QuickCheck manual>
    explains how to write generators and properties;
    it is out-of-date in some details but still full of useful advice.
    .
    A user of QuickCheck has written an unofficial, but detailed, tutorial which
    you can find at
    <https://begriffs.com/posts/2017-01-14-design-use-quickcheck.html>.
category: Testing
author: Koen Claessen <koen@chalmers.se>
exposed: True
indefinite: False
exposed-modules:
    Test.QuickCheck Test.QuickCheck.All Test.QuickCheck.Arbitrary
    Test.QuickCheck.Exception Test.QuickCheck.Function
    Test.QuickCheck.Gen Test.QuickCheck.Gen.Unsafe
    Test.QuickCheck.Modifiers Test.QuickCheck.Monadic
    Test.QuickCheck.Poly Test.QuickCheck.Property
    Test.QuickCheck.Random Test.QuickCheck.State Test.QuickCheck.Test
    Test.QuickCheck.Text
abi: 698e905b23be91d72fd87efbe66c208e
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/QuickCheck-2.10.1
library-dirs: /usr/lib/ghc-8.2.1/site-local/QuickCheck-2.10.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/QuickCheck-2.10.1
hs-libraries: HSQuickCheck-2.10.1-KIwpOgIMAPpCfx99HppzCX
depends:
    base-4.10.0.0 random-1.1-DtLcP2Z2iOOC0RwcSmXjBK containers-0.5.10.2
    transformers-0.5.2.0 deepseq-1.4.3.0 template-haskell-2.12.0.0
    tf-random-0.5-ABDhxe3mXYlHUEE5hzgewx
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             random-1.1-DtLcP2Z2iOOC0RwcSmXjBK=4de0c0628e95d26e613f423e1634f42a
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             template-haskell-2.12.0.0=612ee923b47f5e11502cef08338c9f82
             tf-random-0.5-ABDhxe3mXYlHUEE5hzgewx=ce1337afa07bee49ff5fb070e6d52a19
haddock-interfaces: /usr/share/doc/haskell-quickcheck/html/QuickCheck.haddock
haddock-html: /usr/share/doc/haskell-quickcheck/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

