#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: shake
version: 0.16
id: shake-0.16-FF7YfKrQrFyKNGTPTQnuYS
key: shake-0.16-FF7YfKrQrFyKNGTPTQnuYS
license: BSD3
copyright: Neil Mitchell 2011-2017
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: http://shakebuild.com
synopsis: Build system library, like Make, but more accurate dependencies.
description:
    Shake is a Haskell library for writing build systems - designed as a
    replacement for @make@. See "Development.Shake" for an introduction,
    including an example. Further examples are included in the Cabal tarball,
    under the @Examples@ directory. The homepage contains links to a user
    manual, an academic paper and further information:
    <http://shakebuild.com>
    .
    To use Shake the user writes a Haskell program
    that imports "Development.Shake", defines some build rules, and calls
    the '\''Development.Shake.shakeArgs'\'' function. Thanks to do notation and infix
    operators, a simple Shake build system
    is not too dissimilar from a simple Makefile. However, as build systems
    get more complex, Shake is able to take advantage of the excellent
    abstraction facilities offered by Haskell and easily support much larger
    projects. The Shake library provides all the standard features available in other
    build systems, including automatic parallelism and minimal rebuilds.
    Shake also provides more accurate dependency tracking, including seamless
    support for generated files, and dependencies on system information
    (e.g. compiler version).
category: Development, Shake
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
indefinite: False
exposed-modules:
    Development.Shake Development.Shake.Classes
    Development.Shake.Command Development.Shake.Config
    Development.Shake.FilePath Development.Shake.Forward
    Development.Shake.Rule Development.Shake.Util
hidden-modules: Development.Ninja.Env Development.Ninja.Lexer
                Development.Ninja.Parse Development.Ninja.Type
                Development.Shake.Internal.Args General.Makefile
                Development.Shake.Internal.Core.Action
                Development.Shake.Internal.Core.Rendezvous
                Development.Shake.Internal.Core.Rules
                Development.Shake.Internal.Core.Run
                Development.Shake.Internal.CmdOption
                Development.Shake.Internal.Core.Database
                Development.Shake.Internal.Core.Types
                Development.Shake.Internal.Demo Development.Shake.Internal.Derived
                Development.Shake.Internal.Errors
                Development.Shake.Internal.FileInfo
                Development.Shake.Internal.FilePattern
                Development.Shake.Internal.Core.Monad
                Development.Shake.Internal.Core.Pool
                Development.Shake.Internal.Profile
                Development.Shake.Internal.Progress
                Development.Shake.Internal.Resource
                Development.Shake.Internal.Rules.Directory
                Development.Shake.Internal.Rules.File
                Development.Shake.Internal.Rules.Files
                Development.Shake.Internal.Rules.Oracle
                Development.Shake.Internal.Rules.OrderOnly
                Development.Shake.Internal.Rules.Rerun
                Development.Shake.Internal.Shake
                Development.Shake.Internal.Core.Storage
                Development.Shake.Internal.Options Development.Shake.Internal.Value
                General.Bilist General.Binary General.Chunks General.Cleanup
                General.Concurrent General.Extra General.FileLock General.GetOpt
                General.Ids General.Intern General.ListBuilder General.Process
                Development.Shake.Internal.FileName General.Template General.Timing
                Paths_shake
abi: 72bc52354f5eb3226eb9f86bf281149a
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/shake-0.16
library-dirs: /usr/lib/ghc-8.2.1/site-local/shake-0.16
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/haskell-shake
hs-libraries: HSshake-0.16-FF7YfKrQrFyKNGTPTQnuYS
depends:
    base-4.10.0.0 directory-1.3.0.2
    hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk binary-0.8.5.1
    filepath-1.4.1.2 process-1.6.1.0
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    bytestring-0.10.8.2 utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m
    time-1.8.0.2 random-1.1-DtLcP2Z2iOOC0RwcSmXjBK
    js-jquery-3.2.1-GyZ9FJonY6dAAMhwJ2fANo
    js-flot-0.8.3-JDUwO3yTt2e3BCiAqqIjur transformers-0.5.2.0
    extra-1.6-21C3t0YQFbADxH75E4GqjW deepseq-1.4.3.0
    primitive-0.6.2.0-V0ibjLQDdN6fcQS5bjLVg unix-2.7.2.2
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             binary-0.8.5.1=230c80b11ae3b1af831989b945ccdad4
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m=8d643a529d99a952051170bc6a18d0f2
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             random-1.1-DtLcP2Z2iOOC0RwcSmXjBK=4de0c0628e95d26e613f423e1634f42a
             js-jquery-3.2.1-GyZ9FJonY6dAAMhwJ2fANo=c95978e873dce92420be33e2468b9543
             js-flot-0.8.3-JDUwO3yTt2e3BCiAqqIjur=2de3c18974d6fc1316c6c3f1638d4c5a
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             extra-1.6-21C3t0YQFbADxH75E4GqjW=acd3d4bb5f2e735233df7c17ac347453
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             primitive-0.6.2.0-V0ibjLQDdN6fcQS5bjLVg=998ed6e6951fb3231f40c732faa08c23
             unix-2.7.2.2=7af8630098b53e228272ffaea5bacf62
haddock-interfaces: /usr/share/doc/haskell-shake/html/shake.haddock
haddock-html: /usr/share/doc/haskell-shake/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

