#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tf-random
version: 0.5
id: tf-random-0.5-ABDhxe3mXYlHUEE5hzgewx
key: tf-random-0.5-ABDhxe3mXYlHUEE5hzgewx
license: BSD3
maintainer: Michał Pałka <michal.palka@chalmers.se>
synopsis: High-quality splittable pseudorandom number generator
description:
    This package contains an implementation of a high-quality splittable pseudorandom number generator. The generator is based on a cryptographic hash function built on top of the ThreeFish block cipher. See the paper /Splittable Pseudorandom Number Generators Using Cryptographic Hashing/ by Claessen, Pałka for details and the rationale of the design.
    .
    The package provides the following:
    .
    * A splittable PRNG that implements the standard '\''System.Random.RandomGen'\'' class.
    .
    * The generator also implements an alternative version of the '\''System.Random.TF.Gen.RandomGen'\'' class (exported from "System.Random.TF.Gen"), which requires the generator to return pseudorandom integers from the full 32-bit range, and contains an n-way split function.
    .
    * An alternative version of the @Random@ class is provided, which is linked to the new @RandomGen@ class, together with @Random@ instances for some integral types.
    .
    * Two functions for initialising the generator with a non-deterministic seed: one using the system time, and one using the @\/dev\/urandom@ UNIX special file.
    .
    The package uses an adapted version of the reference C implementation of ThreeFish from the reference package of the Skein hash function (<https://www.schneier.com/skein.html>), originally written by Doug Whiting.
    .
    Please note that even though the generator provides very high-quality pseudorandom numbers, it has not been designed with cryptographic applications in mind.
category: Random
author: Michał Pałka <michal.palka@chalmers.se>
exposed: True
indefinite: False
exposed-modules:
    System.Random.TF System.Random.TF.Gen System.Random.TF.Init
    System.Random.TF.Instances
abi: ce1337afa07bee49ff5fb070e6d52a19
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/tf-random-0.5
library-dirs: /usr/lib/ghc-8.2.1/site-local/tf-random-0.5
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/tf-random-0.5
hs-libraries: HStf-random-0.5-ABDhxe3mXYlHUEE5hzgewx
depends:
    base-4.10.0.0 primitive-0.6.2.0-V0ibjLQDdN6fcQS5bjLVg
    random-1.1-DtLcP2Z2iOOC0RwcSmXjBK time-1.8.0.2
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             primitive-0.6.2.0-V0ibjLQDdN6fcQS5bjLVg=998ed6e6951fb3231f40c732faa08c23
             random-1.1-DtLcP2Z2iOOC0RwcSmXjBK=4de0c0628e95d26e613f423e1634f42a
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
haddock-interfaces: /usr/share/doc/haskell-tf-random/html/tf-random.haddock
haddock-html: /usr/share/doc/haskell-tf-random/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

