/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh.classpath;

import java.net.URL;
import java.net.URLClassLoader;
import org.gjt.sp.jedit.bsh.BshClassManager;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.classpath.BshClassPath;
import org.gjt.sp.jedit.bsh.classpath.ClassManagerImpl;

public class BshClassLoader
extends URLClassLoader {
    BshClassManager classManager;

    public BshClassLoader(BshClassManager bshClassManager, URL[] uRLArray) {
        super(uRLArray);
        this.classManager = bshClassManager;
    }

    public BshClassLoader(BshClassManager bshClassManager, BshClassPath bshClassPath) {
        this(bshClassManager, bshClassPath.getPathComponents());
    }

    protected BshClassLoader(BshClassManager bshClassManager) {
        this(bshClassManager, new URL[0]);
    }

    @Override
    public void addURL(URL uRL) {
        super.addURL(uRL);
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.startsWith("org.gjt.sp.jedit.bsh")) {
            try {
                return Interpreter.class.getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            clazz = this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            throw new ClassNotFoundException("here in loaClass");
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        ClassManagerImpl classManagerImpl = (ClassManagerImpl)this.getClassManager();
        ClassLoader classLoader = classManagerImpl.getLoaderForClass(string);
        if (classLoader != null && classLoader != this) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException("Designated loader could not find class: " + classNotFoundException);
            }
        }
        if (this.getURLs().length > 0) {
            try {
                return super.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((classLoader = classManagerImpl.getBaseLoader()) != null && classLoader != this) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classManagerImpl.plainClassForName(string);
    }

    BshClassManager getClassManager() {
        return this.classManager;
    }
}

