/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.print.BufferPrinter1_7;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrintPreviewPane;
import org.gjt.sp.jedit.print.Range;

public class PrintPreview
extends EnhancedDialog {
    private View view;
    private Buffer buffer;
    private JComboBox<Integer> pages;
    private JButton nextPage;
    private JButton prevPage;
    private JButton zoomIn;
    private JButton zoomOut;
    private JButton fullWidth;
    private JButton fullPage;
    private PrintPreviewPane printPreviewPane;
    private JButton cancelButton;
    private HashMap<Integer, Range> pageRanges;
    private PrintRequestAttributeSet attributes;
    private PrintService printService;
    private PrintPreviewModel model;
    private float zoomLevel = 1.0f;

    public PrintPreview(View view, Buffer buffer, PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        super(view, jEdit.getProperty("printpreview.dialog.title"), true);
        this.view = view;
        this.buffer = buffer;
        this.printService = printService;
        this.attributes = printRequestAttributeSet;
        this.installComponents();
        this.installListeners();
        this.init();
        this.pack();
        this.setLocationRelativeTo(jEdit.getActiveView().getTextArea());
        this.setVisible(true);
        this.repaint();
    }

    private void installComponents() {
        this.pages = new JComboBox();
        this.nextPage = new JButton(GUIUtilities.loadIcon("22x22/actions/go-next.png"));
        this.nextPage.setToolTipText(jEdit.getProperty("printpreview.dialog.nextPage", "Next Page"));
        this.prevPage = new JButton(GUIUtilities.loadIcon("22x22/actions/go-previous.png"));
        this.prevPage.setToolTipText(jEdit.getProperty("printpreview.dialog.prevPage", "Previous Page"));
        this.zoomIn = new JButton(GUIUtilities.loadIcon("22x22/actions/zoom-in.png"));
        this.zoomIn.setToolTipText(jEdit.getProperty("printpreview.dialog.zoomin", "Zoom In"));
        this.zoomOut = new JButton(GUIUtilities.loadIcon("22x22/actions/zoom-out.png"));
        this.zoomOut.setToolTipText(jEdit.getProperty("printpreview.dialog.zoomout", "Zoom Out"));
        this.fullWidth = new JButton(GUIUtilities.loadIcon("22x22/actions/resize-horisontal.png"));
        this.fullWidth.setToolTipText(jEdit.getProperty("printpreview.dialog.pageWidth", "Show page full width"));
        this.fullPage = new JButton(GUIUtilities.loadIcon("22x22/actions/resize-vertical.png"));
        this.fullPage.setToolTipText(jEdit.getProperty("printpreview.dialog.fullPage", "Show full page"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 6, 6));
        jPanel.add(new JLabel("Page "));
        jPanel.add(this.pages);
        jPanel.add(this.prevPage);
        jPanel.add(this.nextPage);
        this.printPreviewPane = new PrintPreviewPane();
        this.cancelButton = new JButton(jEdit.getProperty("common.cancel"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 6, 11));
        jPanel2.add(this.cancelButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)this.printPreviewPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.setContentPane(jPanel3);
    }

    private void installListeners() {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.cancel();
            }
        });
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(225, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(224, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(227, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(226, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(34, 0, false), "none");
        this.pages.getInputMap(1).put(KeyStroke.getKeyStroke(33, 0, false), "none");
        this.pages.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = PrintPreview.this.pages.getSelectedIndex();
                switch (keyEvent.getKeyCode()) {
                    case 34: 
                    case 39: 
                    case 40: 
                    case 225: 
                    case 227: {
                        n = ++n >= PrintPreview.this.pages.getItemCount() ? 0 : n;
                        break;
                    }
                    case 33: 
                    case 37: 
                    case 38: 
                    case 224: 
                    case 226: {
                        n = --n < 0 ? PrintPreview.this.pages.getItemCount() - 1 : n;
                        break;
                    }
                    case 49: {
                        n = 0;
                        break;
                    }
                    case 50: {
                        n = 1;
                        break;
                    }
                    case 51: {
                        n = 2;
                        break;
                    }
                    case 52: {
                        n = 3;
                        break;
                    }
                    case 53: {
                        n = 4;
                        break;
                    }
                    case 54: {
                        n = 5;
                        break;
                    }
                    case 55: {
                        n = 6;
                        break;
                    }
                    case 56: {
                        n = 7;
                        break;
                    }
                    case 57: {
                        n = 8;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                PrintPreview.this.pages.setSelectedIndex(n);
                int n2 = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setPageNumber(n2 - 1);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                PrintPreview.this.attributes.add(new PageRanges(n2));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.prevPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PrintPreview.this.pages.getSelectedIndex();
                n = n <= 0 ? PrintPreview.this.pages.getItemCount() - 1 : --n;
                PrintPreview.this.pages.setSelectedIndex(n);
            }
        });
        this.nextPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PrintPreview.this.pages.getSelectedIndex();
                n = n + 1 == PrintPreview.this.pages.getItemCount() ? 0 : ++n;
                PrintPreview.this.pages.setSelectedIndex(n);
            }
        });
        this.zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.zoomLevel = PrintPreview.this.zoomLevel + 0.1f;
                int n = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                PrintPreview.this.model.setPageNumber(n - 1);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoom(PrintPreviewModel.Zoom.IN);
                PrintPreview.this.attributes.add(new PageRanges(n));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintPreview.this.zoomLevel = PrintPreview.this.zoomLevel - 0.1f;
                if (PrintPreview.this.zoomLevel <= 0.0f) {
                    PrintPreview.this.zoomLevel = 0.1f;
                }
                int n = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setZoomLevel(PrintPreview.this.zoomLevel);
                PrintPreview.this.model.setPageNumber(n - 1);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoom(PrintPreviewModel.Zoom.OUT);
                PrintPreview.this.attributes.add(new PageRanges(n));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.fullWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setPageNumber(n);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoom(PrintPreviewModel.Zoom.WIDTH);
                PrintPreview.this.attributes.add(new PageRanges(n));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
        this.fullPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)PrintPreview.this.pages.getSelectedItem();
                PrintPreview.this.model.setPageNumber(n);
                PrintPreview.this.model.setPageRanges(PrintPreview.this.pageRanges);
                PrintPreview.this.model.setZoom(PrintPreviewModel.Zoom.PAGE);
                PrintPreview.this.attributes.add(new PageRanges(n));
                PrintPreview.this.printPreviewPane.setModel(PrintPreview.this.model);
            }
        });
    }

    private void init() {
        this.pageRanges = BufferPrinter1_7.getPageRanges(this.view, this.buffer, this.attributes);
        DefaultComboBoxModel<Integer> defaultComboBoxModel = new DefaultComboBoxModel<Integer>();
        for (Integer n : this.pageRanges.keySet()) {
            defaultComboBoxModel.addElement(n);
        }
        this.pages.setModel(defaultComboBoxModel);
        this.nextPage.setEnabled(defaultComboBoxModel.getSize() > 1);
        this.prevPage.setEnabled(defaultComboBoxModel.getSize() > 1);
        this.model = new PrintPreviewModel(this.view, this.buffer, this.printService, this.attributes, this.pageRanges);
        this.model.setPageNumber(0);
        this.printPreviewPane.setModel(this.model);
    }

    @Override
    public void ok() {
    }

    @Override
    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

