/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class Tag
implements Tagged,
Map.Entry<String, String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String value;

    public Tag() {
        this("", "");
    }

    public Tag(String key) {
        this(key, "");
    }

    public Tag(String key, String value) {
        this.key = key == null ? "" : key;
        this.value = value == null ? "" : value;
    }

    public Tag(Tag tag) {
        this(tag.getKey(), tag.getValue());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String value) {
        throw new UnsupportedOperationException();
    }

    public boolean matchesKey(String key) {
        return this.key.equals(key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tag tag = (Tag)obj;
        return Objects.equals(this.key, tag.key) && Objects.equals(this.value, tag.value);
    }

    public static Tag ofString(String s) {
        CheckParameterUtil.ensureParameterNotNull(s, "s");
        String[] x = s.split("=", 2);
        if (x.length == 2) {
            return new Tag(x[0], x[1]);
        }
        throw new IllegalArgumentException('\'' + s + "' does not contain '='");
    }

    public String toString() {
        return this.key + '=' + this.value;
    }

    public static String removeWhiteSpaces(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Utils.strip(s).replaceAll("\\s+", " ");
    }

    @Override
    public void setKeys(Map<String, String> keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> getKeys() {
        return Collections.singletonMap(this.key, this.value);
    }

    @Override
    public void put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String get(String k) {
        return this.key.equals(k) ? this.value : null;
    }

    @Override
    public void remove(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasKeys() {
        return true;
    }

    @Override
    public Collection<String> keySet() {
        return Collections.singleton(this.key);
    }

    @Override
    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectionKey() {
        return OsmPrimitive.directionKeys.match(this);
    }
}

