/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class TileSourceDisplaySettings
implements SessionAwareReadApply {
    public static final String AUTO_LOAD = "automatic-downloading";
    public static final String AUTO_ZOOM = "automatically-change-resolution";
    private static final String SHOW_ERRORS = "show-errors";
    private static final String DISPLACEMENT = "displacement";
    private static final String PREFERENCE_PREFIX = "imagery.generic";
    public static final BooleanProperty PROP_AUTO_LOAD = new BooleanProperty("imagery.generic.default_autoload", true);
    public static final BooleanProperty PROP_AUTO_ZOOM = new BooleanProperty("imagery.generic.default_autozoom", true);
    private boolean autoZoom;
    private boolean autoLoad;
    private boolean showErrors;
    private OffsetBookmark offsetBookmark;
    private EastNorth displacement = EastNorth.ZERO;
    private final CopyOnWriteArrayList<DisplaySettingsChangeListener> listeners = new CopyOnWriteArrayList();

    public TileSourceDisplaySettings() {
        this(new String[]{PREFERENCE_PREFIX});
    }

    public TileSourceDisplaySettings(String preferencePrefix) {
        this(PREFERENCE_PREFIX, preferencePrefix);
    }

    private TileSourceDisplaySettings(String ... prefixes) {
        this.autoZoom = TileSourceDisplaySettings.getProperty(prefixes, "default_autozoom");
        this.autoLoad = TileSourceDisplaySettings.getProperty(prefixes, "default_autoload");
        this.showErrors = TileSourceDisplaySettings.getProperty(prefixes, "default_showerrors");
    }

    private static boolean getProperty(String[] prefixes, String name) {
        boolean value = true;
        for (String p : prefixes) {
            String key = p + "." + name;
            boolean currentValue = Config.getPref().getBoolean(key, true);
            if (Config.getPref().get(key).isEmpty()) continue;
            value = currentValue;
        }
        return value;
    }

    public boolean isAutoZoom() {
        return this.autoZoom;
    }

    public void setAutoZoom(boolean autoZoom) {
        this.autoZoom = autoZoom;
        this.fireSettingsChange(AUTO_ZOOM);
    }

    public boolean isAutoLoad() {
        return this.autoLoad;
    }

    public void setAutoLoad(boolean autoLoad) {
        this.autoLoad = autoLoad;
        this.fireSettingsChange(AUTO_LOAD);
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
        this.fireSettingsChange(SHOW_ERRORS);
    }

    public double getDx() {
        return this.displacement.east();
    }

    public double getDy() {
        return this.displacement.north();
    }

    public EastNorth getDisplacement() {
        return this.displacement;
    }

    public void setOffsetBookmark(OffsetBookmark offsetBookmark) {
        this.offsetBookmark = offsetBookmark;
        if (offsetBookmark == null) {
            this.setDisplacement(EastNorth.ZERO);
        } else {
            this.setDisplacement(offsetBookmark.getDisplacement(Main.getProjection()));
        }
    }

    public OffsetBookmark getOffsetBookmark() {
        return this.offsetBookmark;
    }

    private void setDisplacement(EastNorth displacement) {
        CheckParameterUtil.ensure(displacement, DISPLACEMENT, EastNorth::isValid);
        this.displacement = displacement;
        this.fireSettingsChange(DISPLACEMENT);
    }

    private void fireSettingsChange(String changedSetting) {
        DisplaySettingsChangeEvent e = new DisplaySettingsChangeEvent(changedSetting);
        for (DisplaySettingsChangeListener l : this.listeners) {
            l.displaySettingsChanged(e);
        }
    }

    public void addSettingsChangeListener(DisplaySettingsChangeListener l) {
        this.listeners.add(l);
    }

    public void removeSettingsChangeListener(DisplaySettingsChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(AUTO_LOAD, Boolean.toString(this.autoLoad));
        data.put(AUTO_ZOOM, Boolean.toString(this.autoZoom));
        data.put(SHOW_ERRORS, Boolean.toString(this.showErrors));
        return data;
    }

    @Override
    public void applyFromPropertiesMap(Map<String, String> data) {
        try {
            String doShowErrors;
            String doAutoZoom;
            String doAutoLoad = data.get(AUTO_LOAD);
            if (doAutoLoad != null) {
                this.setAutoLoad(Boolean.parseBoolean(doAutoLoad));
            }
            if ((doAutoZoom = data.get(AUTO_ZOOM)) != null) {
                this.setAutoZoom(Boolean.parseBoolean(doAutoZoom));
            }
            if ((doShowErrors = data.get(SHOW_ERRORS)) != null) {
                this.setShowErrors(Boolean.parseBoolean(doShowErrors));
            }
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw BugReport.intercept(e).put("data", data);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autoLoad ? 1231 : 1237);
        result = 31 * result + (this.autoZoom ? 1231 : 1237);
        result = 31 * result + (this.showErrors ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TileSourceDisplaySettings other = (TileSourceDisplaySettings)obj;
        return this.autoLoad == other.autoLoad && this.autoZoom == other.autoZoom && this.showErrors == other.showErrors;
    }

    public String toString() {
        return "TileSourceDisplaySettings [autoZoom=" + this.autoZoom + ", autoLoad=" + this.autoLoad + ", showErrors=" + this.showErrors + ']';
    }

    public static final class DisplaySettingsChangeEvent {
        private final String changedSetting;

        DisplaySettingsChangeEvent(String changedSetting) {
            this.changedSetting = changedSetting;
        }

        public String getChangedSetting() {
            return this.changedSetting;
        }

        public String toString() {
            return "DisplaySettingsChangeEvent [changedSetting=" + this.changedSetting + ']';
        }
    }

    @FunctionalInterface
    public static interface DisplaySettingsChangeListener {
        public void displaySettingsChanged(DisplaySettingsChangeEvent var1);
    }
}

