/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.io.session.AbstractSessionExporter;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Element;

public class ImagerySessionExporter
extends AbstractSessionExporter<ImageryLayer> {
    public ImagerySessionExporter(ImageryLayer layer) {
        super(layer);
    }

    public ImagerySessionExporter(TMSLayer layer) {
        super(layer);
    }

    public ImagerySessionExporter(WMSLayer layer) {
        super(layer);
    }

    public ImagerySessionExporter(WMTSLayer layer) {
        super(layer);
    }

    @Override
    public Component getExportPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.export.setSelected(true);
        JLabel lbl = new JLabel(((ImageryLayer)this.layer).getName(), ((ImageryLayer)this.layer).getIcon(), 2);
        lbl.setToolTipText(((ImageryLayer)this.layer).getToolTipText());
        lbl.setLabelFor(this.export);
        p.add((Component)this.export, GBC.std());
        p.add((Component)lbl, GBC.std());
        p.add(GBC.glue(1, 0), GBC.std().fill(2));
        return p;
    }

    @Override
    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerElem = support.createElement("layer");
        layerElem.setAttribute("type", "imagery");
        layerElem.setAttribute("version", "0.1");
        ImageryInfo.ImageryPreferenceEntry e = new ImageryInfo.ImageryPreferenceEntry(((ImageryLayer)this.layer).getInfo());
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>(StructUtils.serializeStruct(e, ImageryInfo.ImageryPreferenceEntry.class));
        Utils.instanceOfThen(this.layer, AbstractTileSourceLayer.class, tsLayer -> {
            data.putAll(tsLayer.getDisplaySettings().toPropertiesMap());
            if (!tsLayer.getDisplaySettings().isAutoZoom()) {
                data.put("zoom-level", Integer.toString(tsLayer.getZoomLevel()));
            }
        });
        ImagerySessionExporter.addAttributes(layerElem, data, support);
        Utils.instanceOfThen(this.layer, AbstractTileSourceLayer.class, tsLayer -> {
            OffsetBookmark offset = tsLayer.getDisplaySettings().getOffsetBookmark();
            if (offset != null) {
                Map<String, String> offsetProps = offset.toPropertiesMap();
                Element offsetEl = support.createElement("offset");
                layerElem.appendChild(offsetEl);
                ImagerySessionExporter.addAttributes(offsetEl, offsetProps, support);
            }
        });
        ImageryFilterSettings filters = ((ImageryLayer)this.layer).getFilterSettings();
        if (filters != null) {
            HashMap<String, String> filterProps = new HashMap<String, String>();
            filters.getProcessors().stream().flatMap(Utils.castToStream(SessionAwareReadApply.class)).forEach(proc -> filterProps.putAll(proc.toPropertiesMap()));
            if (!filterProps.isEmpty()) {
                Element filterEl = support.createElement("filters");
                layerElem.appendChild(filterEl);
                ImagerySessionExporter.addAttributes(filterEl, filterProps, support);
            }
        }
        return layerElem;
    }

    private static void addAttributes(Element element, Map<String, String> props, SessionWriter.ExportSupport support) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            Element attrElem = support.createElement(entry.getKey());
            element.appendChild(attrElem);
            attrElem.appendChild(support.createTextNode(entry.getValue()));
        }
    }
}

