/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.event;

import org.apache.commons.lang3.Validate;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEventLogger
extends AbstractExecutionListener {
    private final Logger logger;
    private static final int LINE_LENGTH = 72;
    private static final int MAX_PADDED_BUILD_TIME_DURATION_LENGTH = 9;
    private static final int MAX_PROJECT_NAME_LENGTH = 52;

    public ExecutionEventLogger() {
        this.logger = LoggerFactory.getLogger(ExecutionEventLogger.class);
    }

    public ExecutionEventLogger(Logger logger) {
        this.logger = (Logger)Validate.notNull((Object)logger, (String)"logger cannot be null", (Object[])new Object[0]);
    }

    private static String chars(char c, int count) {
        StringBuilder buffer = new StringBuilder(count);
        for (int i = count; i > 0; --i) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    private void infoLine(char c) {
        this.infoMain(ExecutionEventLogger.chars(c, 72));
    }

    private void infoMain(String msg) {
        this.logger.info(MessageUtils.buffer().strong((Object)msg).toString());
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Scanning for projects...");
        }
    }

    public void sessionStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getSession().getProjects().size() > 1) {
            this.infoLine('-');
            this.infoMain("Reactor Build Order:");
            this.logger.info("");
            for (MavenProject project : event.getSession().getProjects()) {
                this.logger.info(project.getName());
            }
        }
    }

    public void sessionEnded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            if (event.getSession().getProjects().size() > 1) {
                this.logReactorSummary(event.getSession());
            }
            this.logResult(event.getSession());
            this.logStats(event.getSession());
            this.infoLine('-');
        }
    }

    private void logReactorSummary(MavenSession session) {
        this.infoLine('-');
        this.infoMain("Reactor Summary:");
        this.logger.info("");
        MavenExecutionResult result = session.getResult();
        for (MavenProject project : session.getProjects()) {
            int padSize;
            String buildTimeDuration;
            BuildSummary buildSummary;
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(project.getName());
            buffer.append(' ');
            if (buffer.length() <= 52) {
                while (buffer.length() < 52) {
                    buffer.append('.');
                }
                buffer.append(' ');
            }
            if ((buildSummary = result.getBuildSummary(project)) == null) {
                buffer.append(MessageUtils.buffer().warning((Object)"SKIPPED"));
            } else if (buildSummary instanceof BuildSuccess) {
                buffer.append(MessageUtils.buffer().success((Object)"SUCCESS"));
                buffer.append(" [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            } else if (buildSummary instanceof BuildFailure) {
                buffer.append(MessageUtils.buffer().failure((Object)"FAILURE"));
                buffer.append(" [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            }
            this.logger.info(buffer.toString());
        }
    }

    private void logResult(MavenSession session) {
        this.infoLine('-');
        MessageBuilder buffer = MessageUtils.buffer();
        if (session.getResult().hasExceptions()) {
            buffer.failure((Object)"BUILD FAILURE");
        } else {
            buffer.success((Object)"BUILD SUCCESS");
        }
        this.logger.info(buffer.toString());
    }

    private void logStats(MavenSession session) {
        this.infoLine('-');
        long finish = System.currentTimeMillis();
        long time = finish - session.getRequest().getStartTime().getTime();
        String wallClock = session.getRequest().getDegreeOfConcurrency() > 1 ? " (Wall Clock)" : "";
        this.logger.info("Total time: " + CLIReportingUtils.formatDuration(time) + wallClock);
        this.logger.info("Finished at: " + CLIReportingUtils.formatTimestamp(finish));
        System.gc();
        Runtime r = Runtime.getRuntime();
        long mb = 0x100000L;
        this.logger.info("Final Memory: " + (r.totalMemory() - r.freeMemory()) / mb + "M/" + r.totalMemory() / mb + "M");
    }

    public void projectSkipped(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            this.infoLine('-');
            this.infoMain("Skipping " + event.getProject().getName());
            this.logger.info("This project has been banned from the build due to previous failures.");
            this.infoLine('-');
        }
    }

    public void projectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            this.infoLine('-');
            this.infoMain("Building " + event.getProject().getName() + " " + event.getProject().getVersion());
            this.infoLine('-');
        }
    }

    public void mojoSkipped(ExecutionEvent event) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Goal " + event.getMojoExecution().getGoal() + " requires online mode for execution but Maven is currently offline, skipping");
        }
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = MessageUtils.buffer().strong((Object)"--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.strong((Object)" ---");
            this.logger.info(buffer.toString());
        }
    }

    public void forkStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = MessageUtils.buffer().strong((Object)">>> ");
            this.append(buffer, event.getMojoExecution());
            buffer.strong((Object)" > ");
            this.appendForkInfo(buffer, event.getMojoExecution().getMojoDescriptor());
            this.append(buffer, event.getProject());
            buffer.strong((Object)" >>>");
            this.logger.info(buffer.toString());
        }
    }

    public void forkSucceeded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = MessageUtils.buffer().strong((Object)"<<< ");
            this.append(buffer, event.getMojoExecution());
            buffer.strong((Object)" < ");
            this.appendForkInfo(buffer, event.getMojoExecution().getMojoDescriptor());
            this.append(buffer, event.getProject());
            buffer.strong((Object)" <<<");
            this.logger.info(buffer.toString());
            this.logger.info("");
        }
    }

    private void append(MessageBuilder buffer, MojoExecution me) {
        buffer.mojo((Object)(me.getArtifactId() + ':' + me.getVersion() + ':' + me.getGoal()));
        if (me.getExecutionId() != null) {
            buffer.a((Object)Character.valueOf(' ')).strong((Object)('(' + me.getExecutionId() + ')'));
        }
    }

    private void appendForkInfo(MessageBuilder buffer, MojoDescriptor md) {
        StringBuilder buff = new StringBuilder();
        if (StringUtils.isNotEmpty((String)md.getExecutePhase())) {
            if (StringUtils.isNotEmpty((String)md.getExecuteLifecycle())) {
                buff.append('[');
                buff.append(md.getExecuteLifecycle());
                buff.append(']');
            }
            buff.append(md.getExecutePhase());
        } else {
            buff.append(':');
            buff.append(md.getExecuteGoal());
        }
        buffer.strong((Object)buff.toString());
    }

    private void append(MessageBuilder buffer, MavenProject project) {
        buffer.a((CharSequence)" @ ").project((Object)project.getArtifactId());
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getMojoExecution().getForkedExecutions().size() > 1) {
            this.logger.info("");
            this.infoLine('>');
            this.infoMain("Forking " + event.getProject().getName() + " " + event.getProject().getVersion());
            this.infoLine('>');
        }
    }
}

