#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc-citeproc
version: 0.12.1
id: pandoc-citeproc-0.12.1-7gwI8rSfZCfAwI3wH1jY02
key: pandoc-citeproc-0.12.1-7gwI8rSfZCfAwI3wH1jY02
license: BSD3
maintainer: jgm@berkeley.edu
homepage: https://github.com/jgm/pandoc-citeproc
synopsis: Supports using pandoc with citeproc
description:
    The pandoc-citeproc library exports functions for
    using the citeproc system with pandoc.  It relies on
    citeproc-hs, a library for rendering
    bibliographic reference citations into a variety
    of styles using a macro language called Citation
    Style Language (CSL). More details on CSL can be
    found here: <http://citationstyles.org/>.
    .
    Currently this package includes a heavily revised
    copy of the citeproc-hs code. When citeproc-hs is
    updated to be compatible, this package will simply
    depend on citeproc-hs.
    .
    This package also contains an executable: pandoc-citeproc,
    which works as a pandoc filter, and
    also has a mode for converting bibliographic databases
    a YAML format suitable for inclusion in pandoc YAML
    metadata.
category: Text
author: John MacFarlane, Andrea Rossato
exposed: True
indefinite: False
exposed-modules:
    Text.CSL Text.CSL.Data Text.CSL.Eval Text.CSL.Eval.Common
    Text.CSL.Eval.Date Text.CSL.Eval.Names Text.CSL.Eval.Output
    Text.CSL.Exception Text.CSL.Input.Bibtex Text.CSL.Input.Bibutils
    Text.CSL.Output.Pandoc Text.CSL.Output.Plain Text.CSL.Pandoc
    Text.CSL.Parser Text.CSL.Proc Text.CSL.Proc.Collapse
    Text.CSL.Proc.Disamb Text.CSL.Reference Text.CSL.Style
hidden-modules: Text.CSL.Util Prelude Paths_pandoc_citeproc
                Text.CSL.Compat.Pandoc
abi: 5ef04bf5945516e2a6bcbc6d51975a83
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/pandoc-citeproc-0.12.1
library-dirs: /usr/lib/ghc-8.2.1/site-local/pandoc-citeproc-0.12.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc-citeproc
hs-libraries: HSpandoc-citeproc-0.12.1-7gwI8rSfZCfAwI3wH1jY02
depends:
    containers-0.5.10.2 directory-1.3.0.2
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 bytestring-0.10.8.2
    filepath-1.4.1.2 pandoc-types-1.17.3-3ez989VQsU1J0DOvUecTA3
    pandoc-2.0.3-27H0I5ezHhX4qU4nUuzDkd
    tagsoup-0.14.1-Dd68OXPvIKPH8wN6EGE1ft
    aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz
    vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi
    xml-conduit-1.7.0-IwZsPRLvd5qEuqVqHgrmPJ
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    data-default-0.7.1.1-7D2kYbZAPZs3NL2w6K0r5J
    setenv-0.1.1.3-BDKZw88F6QnHLVIxtB3r29
    split-0.2.3.2-89BHvn20PlL73pGr1SBIHj
    yaml-0.8.25-KXLr76T0yGA4mwXZdRjC8Y
    hs-bibutils-6.2.0.1-ewhJkVIVTX3sjVOz1mire
    text-icu-0.7.0.1-9QrjjiOgro6L8O3YDKMSJd base-4.10.0.0
    syb-0.7-2rRPTNxBP6YFePrCXw4i2o parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh
    old-locale-1.0.0.7-1sqf81TERjR1yVX7sI2OtM time-1.8.0.2
abi-depends: containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             pandoc-types-1.17.3-3ez989VQsU1J0DOvUecTA3=f532409688b889b3a515baf49102da61
             pandoc-2.0.3-27H0I5ezHhX4qU4nUuzDkd=d57ce7ae49733b8e9c680368eeae0198
             tagsoup-0.14.1-Dd68OXPvIKPH8wN6EGE1ft=8f9438479e2b7a3df6cc973be04bc206
             aeson-1.2.3.0-SQQydLO5BXKh1lJDeeNrq=61053bde0c5cda47d1a123db05d36888
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             vector-0.12.0.1-CnPH69pDwM4A5esizlXfXi=12d01284f86dd305f0b2cab827808cc2
             xml-conduit-1.7.0-IwZsPRLvd5qEuqVqHgrmPJ=a9335b13a8c136c028def553e90bb77b
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             data-default-0.7.1.1-7D2kYbZAPZs3NL2w6K0r5J=51023526c672e559ef5f8b366e37519b
             setenv-0.1.1.3-BDKZw88F6QnHLVIxtB3r29=221ec96ab272bbe35b12c27562404c0e
             split-0.2.3.2-89BHvn20PlL73pGr1SBIHj=c51f43c3e91d41531ae5282d108271a0
             yaml-0.8.25-KXLr76T0yGA4mwXZdRjC8Y=f02d8f40a7e2572d2eefded08e0a6898
             hs-bibutils-6.2.0.1-ewhJkVIVTX3sjVOz1mire=791fa2701c10d2ee03a556b8589cbd19
             text-icu-0.7.0.1-9QrjjiOgro6L8O3YDKMSJd=1736f8873b6635f88b3d95e9fd0e47b8
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             syb-0.7-2rRPTNxBP6YFePrCXw4i2o=119e2c6ac6f570dd5e30835fe9c8c288
             parsec-3.1.11-5WCVqUZr6ypLPXtYWYsMnh=ec025cd9e2938e26fbdb8853642eb58e
             old-locale-1.0.0.7-1sqf81TERjR1yVX7sI2OtM=bb3d8fbe7de4d3cc9ed854226de736b7
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
haddock-interfaces: /usr/share/doc/pandoc-citeproc/html/pandoc-citeproc.haddock
haddock-html: /usr/share/doc/pandoc-citeproc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

