/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.AbstractConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictException;
import org.apache.ivy.util.Message;

public class RegexpConflictManager
extends AbstractConflictManager {
    private Pattern pattern = Pattern.compile("(.*)");
    private boolean mIgnoreNonMatching;

    public void setRegexp(String string) {
        this.pattern = Pattern.compile(string);
        Matcher matcher = this.pattern.matcher("abcdef");
        if (matcher.groupCount() != 1) {
            String string2 = "Pattern does not contain ONE (capturing group): '" + this.pattern + "'";
            Message.error(string2);
            throw new IllegalArgumentException(string2);
        }
    }

    public void setIgnoreNonMatching(boolean bl) {
        this.mIgnoreNonMatching = bl;
    }

    @Override
    public Collection resolveConflicts(IvyNode ivyNode, Collection collection) {
        IvyNode ivyNode2 = null;
        for (IvyNode ivyNode3 : collection) {
            if (ivyNode2 != null && !this.matchEquals(ivyNode3, ivyNode2)) {
                String string = ivyNode2 + ":" + this.getMatch(ivyNode2) + " (needed by " + Arrays.asList(ivyNode2.getAllRealCallers()) + ") conflicts with " + ivyNode3 + ":" + this.getMatch(ivyNode3) + " (needed by " + Arrays.asList(ivyNode3.getAllRealCallers()) + ")";
                throw new StrictConflictException(string);
            }
            if (ivyNode2 != null && !this.nodeIsGreater(ivyNode3, ivyNode2)) continue;
            ivyNode2 = ivyNode3;
        }
        return Collections.singleton(ivyNode2);
    }

    private boolean nodeIsGreater(IvyNode ivyNode, IvyNode ivyNode2) {
        return this.getMatch(ivyNode).compareTo(this.getMatch(ivyNode2)) > 0;
    }

    private boolean matchEquals(IvyNode ivyNode, IvyNode ivyNode2) {
        return this.getMatch(ivyNode).equals(this.getMatch(ivyNode2));
    }

    private String getMatch(IvyNode ivyNode) {
        String string = ivyNode.getId().getRevision();
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            if (string2 != null) {
                return string2;
            }
            this.warnOrThrow("First group of pattern: '" + this.pattern + "' does not match: " + string + " " + ivyNode);
        } else {
            this.warnOrThrow("Pattern: '" + this.pattern + "' does not match: " + string + " " + ivyNode);
        }
        return string;
    }

    private void warnOrThrow(String string) {
        if (!this.mIgnoreNonMatching) {
            throw new StrictConflictException(string);
        }
        Message.warn(string);
    }
}

