/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import java.awt.Image;
import java.awt.image.Raster;

public abstract class PixelBuffer {
    protected PixelFormat format;
    protected int width_;
    protected int height_;
    protected Image image;

    public PixelBuffer(PixelFormat pixelFormat, int n, int n2) {
        this.format = pixelFormat;
        this.width_ = n;
        this.height_ = n2;
    }

    protected PixelBuffer() {
        this.width_ = 0;
        this.height_ = 0;
    }

    public final PixelFormat getPF() {
        return this.format;
    }

    public final int width() {
        return this.width_;
    }

    public final int height() {
        return this.height_;
    }

    public final int area() {
        return this.width_ * this.height_;
    }

    public final Rect getRect() {
        return new Rect(0, 0, this.width_, this.height_);
    }

    public final Rect getRect(Point point) {
        return new Rect(point, point.translate(new Point(this.width_, this.height_)));
    }

    public abstract Raster getBuffer(Rect var1);

    public Image getImage() {
        return this.image;
    }
}

