/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrames;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XModifiable;
import com.sun.star.wizards.common.Desktop;

public class OfficeDocument {
    public static void dispose(XMultiServiceFactory xMSF, XComponent xComponent) {
        try {
            if (xComponent != null) {
                XModifiable xModified = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)xComponent);
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
                XFrame xFrame = xModel.getCurrentController().getFrame();
                if (xModified.isModified()) {
                    xModified.setModified(false);
                }
                Desktop.dispatchURL(xMSF, ".uno:CloseDoc", xFrame);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static XFrame createNewFrame(XMultiServiceFactory xMSF, XTerminateListener listener) {
        return OfficeDocument.createNewFrame(xMSF, listener, "_blank");
    }

    private static XFrame createNewFrame(XMultiServiceFactory xMSF, XTerminateListener listener, String FrameName) {
        XFrame xFrame = null;
        if (FrameName.equalsIgnoreCase("WIZARD_LIVE_PREVIEW")) {
            xFrame = OfficeDocument.createNewPreviewFrame(xMSF, listener);
        } else {
            XFrame xF = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)Desktop.getDesktop(xMSF));
            xFrame = xF.findFrame(FrameName, 0);
            if (listener != null) {
                XFramesSupplier xFS = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)xF);
                XFrames xFF = xFS.getFrames();
                xFF.remove(xFrame);
                XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xF);
                xDesktop.addTerminateListener(listener);
            }
        }
        return xFrame;
    }

    private static XFrame createNewPreviewFrame(XMultiServiceFactory xMSF, XTerminateListener listener) {
        XFrame xFrame = null;
        try {
            XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)xMSF.createInstance("com.sun.star.awt.Toolkit"));
            WindowDescriptor aDescriptor = new WindowDescriptor();
            aDescriptor.Type = WindowClass.TOP;
            aDescriptor.WindowServiceName = "window";
            aDescriptor.ParentIndex = (short)-1;
            aDescriptor.Parent = null;
            aDescriptor.Bounds = new Rectangle(10, 10, 640, 480);
            aDescriptor.WindowAttributes = 524400;
            XWindowPeer xPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)xToolkit.createWindow(aDescriptor));
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xPeer);
            xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)xMSF.createInstance("com.sun.star.frame.Frame"));
            xFrame.initialize(xWindow);
            if (listener != null) {
                Desktop.getDesktop(xMSF).addTerminateListener(listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xFrame;
    }

    public static Object load(XInterface xInterface, String sURL, String sFrame, PropertyValue[] xValues) {
        Object oDocument = null;
        XComponentLoader xComponentLoader = null;
        try {
            xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xInterface);
            XComponent xComponent = xComponentLoader.loadComponentFromURL(sURL, sFrame, 0, xValues);
            XServiceInfo xComponentService = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
            if (xComponentService.supportsService("com.sun.star.text.TextDocument")) {
                oDocument = UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return oDocument;
    }

    public static boolean close(XComponent xComponent) {
        boolean bState = false;
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        if (xModel != null) {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xModel);
            if (xCloseable != null) {
                try {
                    xCloseable.close(true);
                    bState = true;
                }
                catch (CloseVetoException exCloseVeto) {
                    System.out.println("could not close doc");
                    bState = false;
                }
            } else {
                XComponent xDisposeable = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xModel);
                xDisposeable.dispose();
                bState = true;
            }
        }
        return bState;
    }

    public static void ArraytoCellRange(Object[][] datalist, Object oTable, int xpos, int ypos) {
        try {
            int colcount;
            int rowcount = datalist.length;
            if (rowcount > 0 && (colcount = datalist[0].length) > 0) {
                XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, (Object)oTable);
                XCellRange xNewRange = xCellRange.getCellRangeByPosition(xpos, ypos, colcount + xpos - 1, rowcount + ypos - 1);
                XCellRangeData xDataArray = (XCellRangeData)UnoRuntime.queryInterface(XCellRangeData.class, (Object)xNewRange);
                xDataArray.setDataArray(datalist);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

