/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class XContentHelper {
    @Deprecated
    public static XContentParser createParser(NamedXContentRegistry xContentRegistry, BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = compressor.streamInput(bytes.streamInput());
            if (!compressedInput.markSupported()) {
                compressedInput = new BufferedInputStream(compressedInput);
            }
            XContentType contentType = XContentFactory.xContentType(compressedInput);
            return XContentFactory.xContent(contentType).createParser(xContentRegistry, compressedInput);
        }
        return XContentFactory.xContent(bytes).createParser(xContentRegistry, bytes.streamInput());
    }

    public static XContentParser createParser(NamedXContentRegistry xContentRegistry, BytesReference bytes, XContentType xContentType) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = compressor.streamInput(bytes.streamInput());
            if (!compressedInput.markSupported()) {
                compressedInput = new BufferedInputStream(compressedInput);
            }
            return XContentFactory.xContent(xContentType).createParser(xContentRegistry, compressedInput);
        }
        return xContentType.xContent().createParser(xContentRegistry, bytes.streamInput());
    }

    @Deprecated
    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(bytes, ordered, null);
    }

    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, XContentType xContentType) throws ElasticsearchParseException {
        try {
            StreamInput input;
            Compressor compressor = CompressorFactory.compressor(bytes);
            if (compressor != null) {
                InputStream compressedStreamInput = compressor.streamInput(bytes.streamInput());
                if (!compressedStreamInput.markSupported()) {
                    compressedStreamInput = new BufferedInputStream(compressedStreamInput);
                }
                input = compressedStreamInput;
            } else {
                input = bytes.streamInput();
            }
            XContentType contentType = xContentType != null ? xContentType : XContentFactory.xContentType(input);
            return new Tuple<XContentType, Map<String, Object>>(Objects.requireNonNull(contentType), XContentHelper.convertToMap(XContentFactory.xContent(contentType), input, ordered));
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> convertToMap(XContent xContent, String string, boolean ordered) throws ElasticsearchParseException {
        try (XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, string);){
            Map<String, Object> map = ordered ? parser.mapOrdered() : parser.map();
            return map;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> convertToMap(XContent xContent, InputStream input, boolean ordered) throws ElasticsearchParseException {
        try (XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, input);){
            Map<String, Object> map = ordered ? parser.mapOrdered() : parser.map();
            return map;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
        }
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false);
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, prettyPrint, XContentFactory.xContentType(bytes));
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, XContentType xContentType) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false, xContentType);
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint, XContentType xContentType) throws IOException {
        Objects.requireNonNull(xContentType);
        if (xContentType == XContentType.JSON && !reformatJson) {
            return bytes.utf8ToString();
        }
        try (XContentParser parser = XContentFactory.xContent(xContentType).createParser(NamedXContentRegistry.EMPTY, bytes.streamInput());){
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            if (prettyPrint) {
                builder.prettyPrint();
            }
            builder.copyCurrentStructure(parser);
            String string = builder.string();
            return string;
        }
    }

    public static String toString(ToXContent toXContent) {
        return XContentHelper.toString(toXContent, ToXContent.EMPTY_PARAMS);
    }

    public static String toString(ToXContent toXContent, ToXContent.Params params) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            if (params.paramAsBoolean("pretty", true)) {
                builder.prettyPrint();
            }
            if (params.paramAsBoolean("human", true)) {
                builder.humanReadable(true);
            }
            builder.startObject();
            toXContent.toXContent(builder, params);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
                builder.startObject();
                builder.field("error", e.getMessage());
                builder.endObject();
                return builder.string();
            }
            catch (IOException e2) {
                throw new ElasticsearchException("cannot generate error message for deserialization", (Throwable)e, new Object[0]);
            }
        }
    }

    public static boolean update(Map<String, Object> source, Map<String, Object> changes, boolean checkUpdatesAreUnequal) {
        boolean modified = false;
        for (Map.Entry<String, Object> changesEntry : changes.entrySet()) {
            if (!source.containsKey(changesEntry.getKey())) {
                source.put(changesEntry.getKey(), changesEntry.getValue());
                modified = true;
                continue;
            }
            Object old = source.get(changesEntry.getKey());
            if (old instanceof Map && changesEntry.getValue() instanceof Map) {
                modified |= XContentHelper.update((Map)source.get(changesEntry.getKey()), (Map)changesEntry.getValue(), checkUpdatesAreUnequal && !modified);
                continue;
            }
            source.put(changesEntry.getKey(), changesEntry.getValue());
            if (modified) continue;
            if (!checkUpdatesAreUnequal) {
                modified = true;
                continue;
            }
            modified = !Objects.equals(old, changesEntry.getValue());
        }
        return modified;
    }

    public static void mergeDefaults(Map<String, Object> content, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> defaultEntry : defaults.entrySet()) {
            if (!content.containsKey(defaultEntry.getKey())) {
                content.put(defaultEntry.getKey(), defaultEntry.getValue());
                continue;
            }
            if (content.get(defaultEntry.getKey()) instanceof Map && defaultEntry.getValue() instanceof Map) {
                XContentHelper.mergeDefaults((Map)content.get(defaultEntry.getKey()), (Map)defaultEntry.getValue());
                continue;
            }
            if (!(content.get(defaultEntry.getKey()) instanceof List) || !(defaultEntry.getValue() instanceof List)) continue;
            List defaultList = (List)defaultEntry.getValue();
            List contentList = (List)content.get(defaultEntry.getKey());
            ArrayList mergedList = new ArrayList();
            if (XContentHelper.allListValuesAreMapsOfOne(defaultList) && XContentHelper.allListValuesAreMapsOfOne(contentList)) {
                Map.Entry entry;
                Map map;
                LinkedHashMap processed = new LinkedHashMap();
                for (Object o : contentList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    processed.put(entry.getKey(), map);
                }
                for (Object o : defaultList) {
                    map = (Map)o;
                    entry = map.entrySet().iterator().next();
                    if (processed.containsKey(entry.getKey())) {
                        XContentHelper.mergeDefaults((Map)processed.get(entry.getKey()), map);
                        continue;
                    }
                    processed.put(entry.getKey(), map);
                }
                for (Map map2 : processed.values()) {
                    mergedList.add(map2);
                }
            } else {
                mergedList.addAll(defaultList);
                for (Object o : contentList) {
                    if (mergedList.contains(o)) continue;
                    mergedList.add(o);
                }
            }
            content.put(defaultEntry.getKey(), mergedList);
        }
    }

    private static boolean allListValuesAreMapsOfOne(List list) {
        for (Object o : list) {
            if (!(o instanceof Map)) {
                return false;
            }
            if (((Map)o).size() == 1) continue;
            return false;
        }
        return true;
    }

    public static void copyCurrentStructure(XContentGenerator destination, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.FIELD_NAME) {
            destination.writeFieldName(parser.currentName());
            token = parser.nextToken();
        }
        switch (token) {
            case START_ARRAY: {
                destination.writeStartArray();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    XContentHelper.copyCurrentStructure(destination, parser);
                }
                destination.writeEndArray();
                break;
            }
            case START_OBJECT: {
                destination.writeStartObject();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    XContentHelper.copyCurrentStructure(destination, parser);
                }
                destination.writeEndObject();
                break;
            }
            default: {
                XContentHelper.copyCurrentEvent(destination, parser);
            }
        }
    }

    public static void copyCurrentEvent(XContentGenerator generator, XContentParser parser) throws IOException {
        switch (parser.currentToken()) {
            case START_OBJECT: {
                generator.writeStartObject();
                break;
            }
            case END_OBJECT: {
                generator.writeEndObject();
                break;
            }
            case START_ARRAY: {
                generator.writeStartArray();
                break;
            }
            case END_ARRAY: {
                generator.writeEndArray();
                break;
            }
            case FIELD_NAME: {
                generator.writeFieldName(parser.currentName());
                break;
            }
            case VALUE_STRING: {
                if (parser.hasTextCharacters()) {
                    generator.writeString(parser.textCharacters(), parser.textOffset(), parser.textLength());
                    break;
                }
                generator.writeString(parser.text());
                break;
            }
            case VALUE_NUMBER: {
                switch (parser.numberType()) {
                    case INT: {
                        generator.writeNumber(parser.intValue());
                        break;
                    }
                    case LONG: {
                        generator.writeNumber(parser.longValue());
                        break;
                    }
                    case FLOAT: {
                        generator.writeNumber(parser.floatValue());
                        break;
                    }
                    case DOUBLE: {
                        generator.writeNumber(parser.doubleValue());
                    }
                }
                break;
            }
            case VALUE_BOOLEAN: {
                generator.writeBoolean(parser.booleanValue());
                break;
            }
            case VALUE_NULL: {
                generator.writeNull();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                generator.writeBinary(parser.binaryValue());
            }
        }
    }

    @Deprecated
    public static void writeRawField(String field, BytesReference source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Compressor compressor = CompressorFactory.compressor(source);
        if (compressor != null) {
            StreamInput compressedStreamInput = compressor.streamInput(source.streamInput());
            builder.rawField(field, compressedStreamInput);
        } else {
            builder.rawField(field, source);
        }
    }

    public static void writeRawField(String field, BytesReference source, XContentType xContentType, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorFactory.compressor(source);
        if (compressor != null) {
            StreamInput compressedStreamInput = compressor.streamInput(source.streamInput());
            builder.rawField(field, compressedStreamInput, xContentType);
        } else {
            builder.rawField(field, source, xContentType);
        }
    }

    public static BytesReference toXContent(ToXContent toXContent, XContentType xContentType, boolean humanReadable) throws IOException {
        return XContentHelper.toXContent(toXContent, xContentType, ToXContent.EMPTY_PARAMS, humanReadable);
    }

    public static BytesReference toXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder(xContentType.xContent());){
            builder.humanReadable(humanReadable);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            BytesReference bytesReference = builder.bytes();
            return bytesReference;
        }
    }
}

