/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMIHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XMILoad {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String filename;
    private int option;
    private boolean validate;
    private SAXParser parser;
    private XMIFile file;
    private XMIFiles files;
    private XMIHandler handler;
    private ZipFile inZip;
    private InputSource userSource;

    public XMILoad(String string, InputStream inputStream, int n, boolean bl, XMIFiles xMIFiles) {
        this.filename = string;
        this.userSource = inputStream != null ? new InputSource(inputStream) : null;
        this.option = n;
        this.validate = bl;
        this.files = xMIFiles;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.setNamespaceAware(bl);
            sAXParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.parser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private InputSource searchForInputSource() throws Exception {
        String string = null;
        if (this.files != null) {
            string = this.files.getFilepath();
        }
        if (string == null || string.equals("")) {
            return null;
        }
        File file = new File(this.filename);
        if (file.isAbsolute()) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputSource inputSource = null;
            if (zipFile != null) {
                inputSource = this.searchZipFile(zipFile);
                if (inputSource == null) {
                    try {
                        zipFile.close();
                        this.inZip = null;
                    }
                    catch (Exception exception) {}
                } else {
                    this.inZip = zipFile;
                    this.setHandlers(string2);
                }
            } else {
                inputSource = this.searchDirectory(string2);
                this.inZip = null;
            }
            if (inputSource == null) continue;
            return inputSource;
        }
        throw new FileNotFoundException(this.filename);
    }

    private InputSource searchDirectory(String string) throws Exception {
        File file;
        if (string.equals(".")) {
            string = System.getProperty("user.dir");
        }
        if (!(file = new File(string + System.getProperty("file.separator") + this.filename.replace('/', File.separatorChar))).exists()) {
            return null;
        }
        this.setHandlers(file.getPath());
        return new InputSource(new FileInputStream(file));
    }

    private InputSource searchZipFile(ZipFile zipFile) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(this.filename);
        if (zipEntry == null) {
            return null;
        }
        return new InputSource(zipFile.getInputStream(zipEntry));
    }

    private void setHandlers(String string) {
        this.file = new XMIFile(string, this.filename);
        this.file.setExporter(null);
        this.file.setExporterVersion(null);
        this.handler = new XMIHandler(this.file, this.files, this.option);
    }

    public XMIFile load() throws Exception {
        if (this.userSource != null) {
            this.setHandlers(this.filename);
            this.parser.parse(this.userSource, (DefaultHandler)this.handler);
            return this.file;
        }
        ZipFile zipFile = null;
        InputSource inputSource = this.searchForInputSource();
        if (inputSource != null) {
            this.parser.parse(inputSource, (DefaultHandler)this.handler);
            if (this.files != null) {
                this.files.add(this.file);
            }
            try {
                if (this.inZip != null) {
                    this.inZip.close();
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                zipFile = new ZipFile(this.filename);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (zipFile == null) {
                this.setHandlers(this.filename);
                this.parser.parse(new InputSource(new FileInputStream(new File(this.filename))), (DefaultHandler)this.handler);
                if (this.files != null) {
                    this.files.add(this.file);
                }
            } else {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    XMIFile xMIFile = new XMIFile(this.filename);
                    if (this.file == null) {
                        this.file = xMIFile;
                    }
                    this.setHandlers(this.filename);
                    ZipEntry zipEntry = enumeration.nextElement();
                    xMIFile.setEntry(zipEntry.getName());
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    if (this.files != null) {
                        xMIFile = this.files.load(zipEntry.getName(), inputStream, this.option, this.validate);
                    } else {
                        InputSource inputSource2 = new InputSource(inputStream);
                        this.parser.parse(inputSource2, (DefaultHandler)this.handler);
                    }
                    if (this.files == null) continue;
                    this.files.add(xMIFile);
                }
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.file;
    }
}

