/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.StackMarker;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXGlue;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.primitives.EndCs;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Vector;

public class TeXObjectList
extends Vector<TeXObject>
implements TeXObject,
Expandable,
CaseChangeable {
    private ArrayDeque<Declaration> declarations = new ArrayDeque();

    public TeXObjectList() {
    }

    public TeXObjectList(int n) {
        super(n);
    }

    public TeXObjectList(TeXParserListener teXParserListener, String string) {
        this(string.length() > 0 ? string.length() : 10);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.add(teXParserListener.getOther(string.codePointAt(i)));
        }
    }

    public TeXObject expandedPopStack(TeXParser teXParser) throws IOException {
        return this.expandedPopStack(teXParser, false);
    }

    public TeXObject expandedPopStack(TeXParser teXParser, boolean bl) throws IOException {
        TeXObjectList teXObjectList;
        if (this.size() == 0) {
            return null;
        }
        this.flatten();
        TeXObject teXObject = this.popStack(teXParser, bl);
        if (teXObject instanceof TeXCsRef && (teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName())) instanceof EndCs) {
            return teXObject;
        }
        if (teXObject instanceof Group) {
            teXObjectList = (Group)teXObject;
            TeXObjectList teXObjectList2 = teXObjectList.expandfully(teXParser, this);
            if (teXObjectList2.get(0) instanceof BgChar) {
                BgChar bgChar = (BgChar)teXObjectList2.remove(0);
                teXObjectList = bgChar.createGroup(teXParser);
                teXObjectList2.popRemainingGroup(teXParser, (Group)teXObjectList, bl, bgChar);
                if (!teXObjectList2.isEmpty()) {
                    this.addAll(0, teXObjectList2);
                }
                return teXObjectList;
            }
            this.addAll(0, teXObjectList2);
            teXObject = this.popStack(teXParser, bl);
        }
        if (teXObject instanceof BgChar) {
            teXObjectList = ((BgChar)teXObject).createGroup(teXParser);
            this.popRemainingGroup(teXParser, (Group)teXObjectList, bl, (BgChar)teXObject);
            return teXObjectList;
        }
        if (!(teXObject instanceof Expandable)) {
            return teXObject;
        }
        teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser, this);
        if (teXObjectList == null) {
            return teXObject;
        }
        return teXObjectList;
    }

    public TeXObject popStack(TeXParser teXParser) throws IOException {
        return this.popStack(teXParser, false);
    }

    public TeXObject popStack(TeXParser teXParser, boolean bl) throws IOException {
        while (this.size() > 0 && this.get(0) instanceof Ignoreable) {
            this.remove(0);
        }
        if (this.size() == 0) {
            return null;
        }
        TeXObject teXObject = (TeXObject)this.remove(0);
        if (bl && teXObject.isPar()) {
            throw new TeXSyntaxException(teXParser, "tex.error.par_before_eg");
        }
        if (teXObject instanceof BgChar) {
            Group group = ((BgChar)teXObject).createGroup(teXParser);
            this.popRemainingGroup(teXParser, group, bl, (BgChar)teXObject);
            return group;
        }
        return teXObject;
    }

    public TeXObject popToken() throws IOException {
        while (this.size() > 0 && this.get(0) instanceof Ignoreable) {
            this.remove(0);
        }
        if (this.size() == 0) {
            return null;
        }
        return (TeXObject)this.remove(0);
    }

    public TeXObject pop() throws IOException {
        if (this.isEmpty()) {
            return null;
        }
        return (TeXObject)this.remove(0);
    }

    public TeXObjectList popToGroup(TeXParser teXParser, boolean bl) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (true) {
            if (this.size() == 0) {
                throw new TeXSyntaxException(teXParser, "tex.error.syntax", this.toString(teXParser));
            }
            TeXObject teXObject = (TeXObject)this.firstElement();
            if (teXObject instanceof Group || teXObject instanceof BgChar) break;
            teXObject = (TeXObject)this.remove(0);
            if (teXObject instanceof Ignoreable) {
                teXParser.getListener().skipping((Ignoreable)teXObject);
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public TeXUnit popUnit(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, true);
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser.getCurrentFile(), teXParser.getLineNumber(), "tex.error.missing_unit");
        }
        if (teXObject instanceof CharObject) {
            char c = (char)((CharObject)teXObject).getCharCode();
            TeXObject teXObject2 = this.expandedPopStack(teXParser);
            if (teXObject2 == null || !(teXObject2 instanceof CharObject)) {
                this.push(teXObject);
                throw new TeXSyntaxException(teXParser.getCurrentFile(), teXParser.getLineNumber(), "tex.error.missing_unit");
            }
            char c2 = (char)((CharObject)teXObject2).getCharCode();
            try {
                return teXParser.getListener().createUnit(String.format("%c%c", Character.valueOf(c), Character.valueOf(c2)));
            }
            catch (TeXSyntaxException teXSyntaxException) {
                if (c == 'f' && c2 == 'i') {
                    TeXObject teXObject3 = this.expandedPopStack(teXParser);
                    if (teXObject3 == null || !(teXObject3 instanceof CharObject) || ((CharObject)teXObject3).getCharCode() != 108) {
                        this.push(teXObject3);
                    } else {
                        TeXObject teXObject4 = this.expandedPopStack(teXParser);
                        if (teXObject4 == null || !(teXObject4 instanceof CharObject) || ((CharObject)teXObject4).getCharCode() != 108) {
                            this.push(teXObject4);
                            return TeXUnit.FIL;
                        }
                        TeXObject teXObject5 = this.expandedPopStack(teXParser);
                        if (teXObject5 == null || teXObject5 instanceof CharObject || ((CharObject)teXObject5).getCharCode() != 108) {
                            this.push(teXObject5);
                            return TeXUnit.FILL;
                        }
                        return TeXUnit.FILLL;
                    }
                }
                this.push(teXObject2);
                this.push(teXObject);
                throw new TeXSyntaxException(teXParser.getCurrentFile(), teXParser.getLineNumber(), "tex.error.missing_unit");
            }
        }
        this.push(teXObject);
        throw new TeXSyntaxException(teXParser.getCurrentFile(), teXParser.getLineNumber(), "tex.error.missing_unit");
    }

    public Numerical popNumerical(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, true);
        if (teXObject instanceof Register) {
            return (Register)teXObject;
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        this.push(teXObject);
        return this.popNumber(teXParser);
    }

    public TeXDimension popDimension(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, true);
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        this.push(teXObject);
        Float f = this.popFloat(teXParser);
        teXObject = this.expandedPopStack(teXParser);
        if (teXObject instanceof DimenRegister) {
            TeXGlue teXGlue = new TeXGlue(teXParser, (DimenRegister)teXObject);
            teXGlue.multiply(f.floatValue());
            return teXGlue;
        }
        this.push(teXObject);
        TeXUnit teXUnit = this.popUnit(teXParser);
        UserDimension userDimension = new UserDimension(f, teXUnit);
        TeXDimension teXDimension = null;
        TeXDimension teXDimension2 = null;
        teXObject = this.expandedPopStack(teXParser);
        this.push(teXObject);
        if (!(teXObject instanceof CharObject)) {
            return userDimension;
        }
        if (((CharObject)teXObject).getCharCode() == 112) {
            teXDimension = this.popStretch(teXParser);
            if (teXDimension == null) {
                return userDimension;
            }
            teXObject = this.expandedPopStack(teXParser);
            this.push(teXObject);
            if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 109) {
                teXDimension2 = this.popShrink(teXParser);
            }
        } else if (((CharObject)teXObject).getCharCode() == 109) {
            teXDimension2 = this.popShrink(teXParser);
            if (teXDimension2 == null) {
                return userDimension;
            }
        } else {
            return userDimension;
        }
        return new TeXGlue(teXParser, userDimension, teXDimension, teXDimension2);
    }

    private TeXDimension popStretch(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, true);
        if (!(teXObject instanceof CharObject) || ((CharObject)teXObject).getCharCode() != 112) {
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject2 = this.expandedPopStack(teXParser, true);
        if (!(teXObject2 instanceof CharObject) || ((CharObject)teXObject2).getCharCode() != 108) {
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject3 = this.expandedPopStack(teXParser, true);
        if (!(teXObject3 instanceof CharObject) || ((CharObject)teXObject3).getCharCode() != 117) {
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject4 = this.expandedPopStack(teXParser, true);
        if (!(teXObject4 instanceof CharObject) || ((CharObject)teXObject4).getCharCode() != 115) {
            this.push(teXObject4);
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        Float f = this.popFloat(teXParser);
        teXObject = this.expandedPopStack(teXParser, true);
        if (teXObject instanceof DimenRegister) {
            UserDimension userDimension = new UserDimension();
            userDimension.setDimension(teXParser, (DimenRegister)teXObject);
            userDimension.multiply(f.floatValue());
            return userDimension;
        }
        this.push(teXObject);
        TeXUnit teXUnit = this.popUnit(teXParser);
        return new UserDimension(f, teXUnit);
    }

    private TeXDimension popShrink(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, true);
        if (!(teXObject instanceof CharObject) || ((CharObject)teXObject).getCharCode() != 109) {
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject2 = this.expandedPopStack(teXParser, true);
        if (!(teXObject2 instanceof CharObject) || ((CharObject)teXObject2).getCharCode() != 105) {
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject3 = this.expandedPopStack(teXParser, true);
        if (!(teXObject3 instanceof CharObject) || ((CharObject)teXObject3).getCharCode() != 110) {
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject4 = this.expandedPopStack(teXParser, true);
        if (!(teXObject4 instanceof CharObject) || ((CharObject)teXObject4).getCharCode() != 117) {
            this.push(teXObject4);
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        TeXObject teXObject5 = this.expandedPopStack(teXParser, true);
        if (!(teXObject5 instanceof CharObject) || ((CharObject)teXObject5).getCharCode() != 115) {
            this.push(teXObject5);
            this.push(teXObject4);
            this.push(teXObject3);
            this.push(teXObject2);
            this.push(teXObject);
            return null;
        }
        Float f = this.popFloat(teXParser);
        teXObject = this.expandedPopStack(teXParser, true);
        if (teXObject instanceof DimenRegister) {
            UserDimension userDimension = new UserDimension();
            userDimension.setDimension(teXParser, (DimenRegister)teXObject);
            userDimension.multiply(f.floatValue());
            return userDimension;
        }
        this.push(teXObject);
        TeXUnit teXUnit = this.popUnit(teXParser);
        return new UserDimension(f, teXUnit);
    }

    public Float popFloat(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser);
        StringBuilder stringBuilder = new StringBuilder();
        this.popFloat(teXParser, teXObject, stringBuilder);
        String string = stringBuilder.toString();
        try {
            return Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", string);
        }
    }

    protected void popFloat(TeXParser teXParser, TeXObject teXObject, StringBuilder stringBuilder) throws IOException {
        if (teXObject == null) {
            return;
        }
        String string = teXObject.toString(teXParser);
        try {
            Float.parseFloat(stringBuilder.toString() + string + "0");
        }
        catch (NumberFormatException numberFormatException) {
            this.push(teXObject);
            return;
        }
        stringBuilder.append(string);
        this.popFloat(teXParser, this.expandedPopStack(teXParser), stringBuilder);
    }

    public TeXNumber popNumber(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser);
        if (teXObject instanceof TeXNumber) {
            return (TeXNumber)teXObject;
        }
        if (teXObject instanceof Group) {
            return ((Group)teXObject).toList().popNumber(teXParser);
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.popNumber(teXParser, teXObject, stringBuilder);
        return new UserNumber(teXParser, stringBuilder.toString());
    }

    protected void popNumber(TeXParser teXParser, TeXObject teXObject, StringBuilder stringBuilder) throws IOException {
        if (teXObject == null) {
            return;
        }
        String string = teXObject.toString(teXParser);
        try {
            Integer.parseInt(stringBuilder.toString() + string);
        }
        catch (NumberFormatException numberFormatException) {
            this.push(teXObject);
            return;
        }
        stringBuilder.append(string);
        this.popNumber(teXParser, this.expandedPopStack(teXParser), stringBuilder);
    }

    public void push(TeXObject teXObject) {
        if (teXObject == this) {
            throw new IllegalArgumentException("Can't add list to itself");
        }
        if (teXObject != null) {
            this.add(0, teXObject);
        }
    }

    @Override
    public void add(int n, TeXObject teXObject) {
        if (teXObject == null) {
            throw new NullPointerException();
        }
        super.add(n, teXObject);
    }

    @Override
    public boolean add(TeXObject teXObject) {
        if (teXObject == null) {
            throw new NullPointerException();
        }
        if (teXObject == this) {
            throw new IllegalArgumentException("Can't add a list to itself");
        }
        return super.add(teXObject);
    }

    public TeXObject peek() {
        return this.size() == 0 ? null : (TeXObject)this.firstElement();
    }

    public TeXObject peekStack() throws IOException {
        if (this.size() == 0) {
            return null;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (teXObject instanceof Ignoreable) continue;
            return teXObject;
        }
        return null;
    }

    public TeXObject popArg(TeXParser teXParser) throws IOException {
        return this.popArg(teXParser, false);
    }

    public TeXObject popArg(TeXParser teXParser, boolean bl) throws IOException {
        return this.popArg(teXParser, bl, true);
    }

    public TeXObject popArg(TeXParser teXParser, boolean bl, boolean bl2) throws IOException {
        TeXObject teXObject = this.popStack(teXParser, bl);
        if (bl2) {
            while (teXObject instanceof WhiteSpace) {
                teXObject = this.popStack(teXParser, bl);
            }
        }
        if (teXObject instanceof Group && !(teXObject instanceof MathGroup)) {
            return ((Group)teXObject).toList();
        }
        return teXObject;
    }

    public TeXObject popArg(TeXParser teXParser, char c, char c2) throws IOException {
        return this.popArg(teXParser, false, c, c2);
    }

    public TeXObject popArg(TeXParser teXParser, boolean bl, char c, char c2) throws IOException {
        TeXObject teXObject = this.popStack(teXParser, bl);
        if (!(teXObject instanceof CharObject)) {
            this.push(teXObject);
            return null;
        }
        CharObject charObject = (CharObject)teXObject;
        if (charObject.getCharCode() != c) {
            this.push(teXObject);
            return null;
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        while ((teXObject = this.pop()) != null) {
            if (teXObject instanceof CharObject) {
                charObject = (CharObject)teXObject;
                if (charObject.getCharCode() == c2) {
                    return teXObjectList;
                }
            } else if (teXObject instanceof BgChar) {
                Group group = teXParser.getListener().createGroup();
                this.popRemainingGroup(teXParser, group, bl, (BgChar)teXObject);
                teXObject = group;
            } else if (bl && teXObject.isPar()) break;
            teXObjectList.add(teXObject);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.missing_closing", "" + c2);
    }

    public Numerical popNumericalArg(TeXParser teXParser, char c, char c2) throws IOException {
        TeXObject teXObject = this.popArg(teXParser, true, c, c2);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)((Object)teXObject);
        }
        TeXObjectList teXObjectList = null;
        if (teXObject instanceof Expandable) {
            teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser, this);
        }
        if (teXObjectList != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popNumerical(teXParser);
        }
        return new UserNumber(teXParser, teXObject.toString(teXParser));
    }

    @Override
    public TeXObjectList toLowerCase(TeXParser teXParser) {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof CaseChangeable) {
                teXObjectList.add(((CaseChangeable)((Object)teXObject)).toLowerCase(teXParser));
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                if (teXObject instanceof Primitive || teXObject instanceof MathSymbol) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                teXObjectList.add(new TeXCsRef(((ControlSequence)teXObject).getName().toLowerCase()));
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList toUpperCase(TeXParser teXParser) {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof CaseChangeable) {
                teXObjectList.add(((CaseChangeable)((Object)teXObject)).toUpperCase(teXParser));
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                if (teXObject instanceof Primitive || teXObject instanceof MathSymbol) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                teXObjectList.add(new TeXCsRef(((ControlSequence)teXObject).getName().toUpperCase()));
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public TeXObjectList createList() {
        return new TeXObjectList(this.capacity());
    }

    @Override
    public Object clone() {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            teXObjectList.add((TeXObject)teXObject.clone());
        }
        for (Declaration declaration : this.declarations) {
            teXObjectList.declarations.add((Declaration)declaration.clone());
        }
        return teXObjectList;
    }

    protected void flatten() {
        for (int i = this.size() - 1; i >= 0; --i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (!(teXObject instanceof TeXObjectList)) continue;
            ((TeXObjectList)teXObject).flatten();
            if (teXObject instanceof Group) continue;
            this.remove(i);
            this.addAll(i, (TeXObjectList)teXObject);
        }
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        this.flatten();
        TeXObjectList teXObjectList = new TeXObjectList(this.size());
        TeXObjectList teXObjectList2 = (TeXObjectList)this.clone();
        while (!teXObjectList2.isEmpty()) {
            TeXObject teXObject = (TeXObject)teXObjectList2.remove(0);
            TeXObjectList teXObjectList3 = null;
            if (teXObject instanceof Expandable) {
                teXObjectList3 = ((Expandable)((Object)teXObject)).expandonce(teXParser, teXObjectList2);
            }
            if (teXObjectList3 == null) {
                teXObjectList.add(teXObject);
                continue;
            }
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        this.flatten();
        TeXObjectList teXObjectList2 = new TeXObjectList(this.size());
        TeXObjectList teXObjectList3 = (TeXObjectList)this.clone();
        StackMarker stackMarker = null;
        if (teXObjectList != null && teXObjectList != teXParser) {
            stackMarker = new StackMarker();
            teXObjectList3.add(stackMarker);
            teXObjectList3.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (!teXObjectList3.isEmpty() && !(teXObject = (TeXObject)teXObjectList3.remove(0)).equals(stackMarker)) {
            TeXObjectList teXObjectList4 = null;
            if (teXObject instanceof Expandable) {
                teXObjectList4 = ((Expandable)((Object)teXObject)).expandonce(teXParser, teXObjectList3);
            }
            if (teXObjectList4 == null) {
                teXObjectList2.add(teXObject);
                continue;
            }
            teXObjectList2.addAll(teXObjectList4);
        }
        if (!teXObjectList3.isEmpty()) {
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        this.flatten();
        TeXObjectList teXObjectList = new TeXObjectList(this.size());
        TeXObjectList teXObjectList2 = (TeXObjectList)this.clone();
        while (!teXObjectList2.isEmpty()) {
            TeXObject teXObject = (TeXObject)teXObjectList2.remove(0);
            TeXObjectList teXObjectList3 = null;
            if (teXObject instanceof Expandable) {
                teXObjectList3 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList2);
            }
            if (teXObjectList3 == null) {
                teXObjectList.add(teXObject);
                continue;
            }
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        this.flatten();
        TeXObjectList teXObjectList2 = new TeXObjectList(this.size());
        TeXObjectList teXObjectList3 = (TeXObjectList)this.clone();
        StackMarker stackMarker = null;
        if (teXObjectList != null && teXObjectList != teXParser) {
            stackMarker = new StackMarker();
            teXObjectList3.add(stackMarker);
            teXObjectList3.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (!teXObjectList3.isEmpty() && !(teXObject = (TeXObject)teXObjectList3.remove(0)).equals(stackMarker)) {
            TeXObjectList teXObjectList4 = null;
            if (teXObject instanceof Expandable) {
                teXObjectList4 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList3);
            }
            if (teXObjectList4 == null) {
                teXObjectList2.add(teXObject);
                continue;
            }
            teXObjectList2.addAll(teXObjectList4);
        }
        if (!teXObjectList3.isEmpty()) {
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        while (this.size() > 0) {
            TeXObject teXObject = (TeXObject)this.remove(0);
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof Declaration) {
                this.pushDeclaration((Declaration)teXObject);
            }
            if (teXObject instanceof Ignoreable) continue;
            teXObject.process(teXParser, this);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        StackMarker stackMarker = null;
        if (teXObjectList != teXParser && teXObjectList != null) {
            stackMarker = new StackMarker();
            this.add(stackMarker);
            this.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (this.size() > 0 && !(teXObject = (TeXObject)this.remove(0)).equals(stackMarker)) {
            if (teXObject instanceof TeXCsRef) {
                teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
            }
            if (teXObject instanceof Declaration) {
                this.pushDeclaration((Declaration)teXObject);
            }
            if (teXObject instanceof Ignoreable) continue;
            teXObject.process(teXParser, this);
        }
        if (!this.isEmpty()) {
            teXObjectList.addAll(this);
            this.clear();
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (teXObject instanceof CharObject) {
                stringBuilder.append('\'');
                stringBuilder.append(teXObject.toString());
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(teXObject.toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            stringBuilder.append(teXObject.format());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            stringBuilder.append(teXObject.toString(teXParser));
            if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).isControlWord(teXParser) || i >= n - 1) continue;
            teXObject = (TeXObject)this.get(i + 1);
            if (teXObject instanceof Letter) {
                stringBuilder.append(" ");
                continue;
            }
            if (!(teXObject instanceof TeXObjectList) || teXObject instanceof Group) continue;
            ++i;
            String string = ((TeXObjectList)teXObject).toString(teXParser);
            if (string.isEmpty()) continue;
            if (teXParser.isLetter(string.charAt(0))) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        if (this.size() == 0) {
            return this;
        }
        TeXObjectList teXObjectList = this.pop().string(teXParser);
        this.addAll(0, teXObjectList);
        return this;
    }

    public void pushDeclaration(Declaration declaration) {
        this.declarations.add(declaration);
    }

    public void processEndDeclarations(TeXParser teXParser) throws IOException {
        while (this.declarations.size() > 0) {
            this.declarations.pollLast().end(teXParser);
        }
    }

    @Override
    public boolean isPar() {
        return this.size() == 1 && ((TeXObject)this.firstElement()).isPar();
    }

    public boolean popRemainingGroup(TeXParser teXParser, Group group, boolean bl, BgChar bgChar) throws IOException {
        while (this.size() > 0) {
            TeXObject teXObject = (TeXObject)this.remove(0);
            if (teXObject instanceof EgChar) {
                if (!((EgChar)teXObject).matches(bgChar)) {
                    throw new TeXSyntaxException(teXParser, "tex.error.extra_or_forgotten", new String[]{teXObject.toString(teXParser), bgChar.toString(teXParser)});
                }
                return true;
            }
            if (bl && teXObject.isPar()) {
                throw new TeXSyntaxException(teXParser, "tex.error.par_before_eg");
            }
            if (teXObject instanceof BgChar) {
                Group group2 = ((BgChar)teXObject).createGroup(teXParser);
                if (!this.popRemainingGroup(teXParser, group2, bl, (BgChar)teXObject)) {
                    group.add(group2);
                    return false;
                }
                group.add(group2);
                continue;
            }
            group.add(teXObject);
        }
        return false;
    }
}

