/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.bib.At;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibString;
import com.dickimawbooks.texparserlib.generic.DefaultTeXParserListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Vector;

public class BibParser
extends DefaultTeXParserListener
implements Writeable {
    private Vector<BibData> bibData;
    private TeXApp texApp;
    private Charset charset = null;

    public BibParser(TeXApp teXApp) throws IOException {
        this(teXApp, null);
    }

    public BibParser(TeXApp teXApp, Charset charset) throws IOException {
        super(null);
        this.texApp = teXApp;
        this.charset = charset;
        this.setWriteable(this);
        this.bibData = new Vector();
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }

    public TeXParser parseBibFile(File file) throws IOException {
        return this.parseBibFile(file, null);
    }

    public TeXParser parseBibFile(File file, Charset charset) throws IOException {
        if (charset != null) {
            this.charset = charset;
        }
        TeXParser teXParser = new TeXParser(this);
        int n = teXParser.getCatCode('@');
        int n2 = teXParser.getCatCode('#');
        int n3 = teXParser.getCatCode('~');
        teXParser.setCatCode('@', 13);
        teXParser.setCatCode('#', 12);
        teXParser.setCatCode('~', 12);
        teXParser.parse(file);
        teXParser.setCatCode('@', n);
        teXParser.setCatCode('#', n2);
        teXParser.setCatCode('~', n3);
        return teXParser;
    }

    @Override
    protected void addPredefined() {
        this.parser.putActiveChar(new At());
    }

    @Override
    public Writeable getWriteable() {
        return this;
    }

    @Override
    public void write(String string) throws IOException {
    }

    @Override
    public void writeln(String string) throws IOException {
    }

    @Override
    public void write(char c) throws IOException {
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file) throws IOException {
        this.getTeXApp().message(this.getTeXApp().getMessage("message.reading", file.getAbsolutePath()));
    }

    public void addBibData(BibData bibData) {
        this.bibData.add(bibData);
    }

    public BibEntry getBibEntry(String string) {
        for (BibData bibData : this.bibData) {
            if (!(bibData instanceof BibEntry) || !((BibEntry)bibData).getId().equals(string)) continue;
            return (BibEntry)bibData;
        }
        return null;
    }

    public BibString getBibString(String string) {
        for (BibData bibData : this.bibData) {
            if (!(bibData instanceof BibString) || !((BibString)bibData).getKey().equals(string)) continue;
            return (BibString)bibData;
        }
        return null;
    }

    public Vector<BibData> getBibData() {
        return this.bibData;
    }

    @Override
    public Charset getCharSet() {
        return this.charset;
    }

    @Override
    public float emToPt(float f) {
        this.getTeXApp().warning(this.getParser(), "Can't convert from em to pt, no font information loaded");
        return 9.5f * f;
    }

    @Override
    public float exToPt(float f) {
        this.getTeXApp().warning(this.getParser(), "Can't convert from ex to pt, no font information loaded");
        return 4.4f * f;
    }
}

