/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.OtherGroupTitle;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.text.BreakIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;

public class Bib2GlsEntryComparator
implements Comparator<Bib2GlsEntry> {
    private String sortField;
    private Collator collator;
    private BreakIterator breakIterator;
    private String breakPointMarker = "|";
    private Bib2Gls bib2gls;
    private Vector<Bib2GlsEntry> entries;
    public static final int BREAK_NONE = 0;
    public static final int BREAK_WORD = 1;
    public static final int BREAK_CHAR = 2;
    public static final int BREAK_SENTENCE = 3;

    public Bib2GlsEntryComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, Locale locale, String string, int n, int n2) {
        this(bib2Gls, vector, locale, string, n, n2, 1, "|");
    }

    public Bib2GlsEntryComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, Locale locale, String string, int n, int n2, int n3, String string2) {
        this.sortField = string;
        this.bib2gls = bib2Gls;
        this.entries = vector;
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(n);
        this.collator.setDecomposition(n2);
        if (this.collator instanceof RuleBasedCollator && bib2Gls.getDebugLevel() > 0) {
            bib2Gls.debug(bib2Gls.getMessage("message.collator.rules", ((RuleBasedCollator)this.collator).getRules()));
        }
        this.setBreakPoint(n3, string2, locale);
    }

    public Bib2GlsEntryComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, String string, int n, int n2, String string2) throws ParseException {
        this(bib2Gls, vector, string, n, n2, string2, 1, "|");
    }

    public Bib2GlsEntryComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, String string, int n, int n2, String string2, int n3, String string3) throws ParseException {
        this.sortField = string;
        this.bib2gls = bib2Gls;
        this.entries = vector;
        this.collator = new RuleBasedCollator(string2);
        this.collator.setStrength(n);
        this.collator.setDecomposition(n2);
        if (bib2Gls.getDebugLevel() > 0) {
            bib2Gls.debug(bib2Gls.getMessage("message.collator.rules", ((RuleBasedCollator)this.collator).getRules()));
        }
        if (n3 != 0) {
            String string4 = bib2Gls.getDocDefaultLocale();
            this.setBreakPoint(n3, string3, Locale.forLanguageTag(string4));
        }
    }

    private void setBreakPoint(int n, String string, Locale locale) {
        this.breakPointMarker = string;
        switch (n) {
            case 0: {
                this.breakIterator = null;
                break;
            }
            case 1: {
                this.breakIterator = BreakIterator.getWordInstance(locale);
                break;
            }
            case 2: {
                this.breakIterator = BreakIterator.getCharacterInstance(locale);
                break;
            }
            case 3: {
                this.breakIterator = BreakIterator.getSentenceInstance(locale);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid break identifier: " + n);
            }
        }
    }

    private String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        Object object;
        String string = bib2GlsEntry.getId();
        String string2 = null;
        if (this.sortField.equals("id")) {
            string2 = string;
        } else {
            string2 = bib2GlsEntry.getFieldValue(this.sortField);
            object = bib2GlsEntry.getField(this.sortField);
            if (string2 == null) {
                string2 = bib2GlsEntry.getFallbackValue(this.sortField);
                object = bib2GlsEntry.getFallbackContents(this.sortField);
            }
            if (string2 == null) {
                string2 = string;
                this.bib2gls.debug(this.bib2gls.getMessage("warning.no.default.sort", string, this.sortField));
            } else if (this.bib2gls.useInterpreter() && object != null && string2.matches(".*[\\\\\\$\\{\\}].*")) {
                string2 = this.bib2gls.interpret(string2, (BibValueList)object);
            }
        }
        bib2GlsEntry.putField("sort", string2);
        object = null;
        string2 = this.breakPoints(string2).toString();
        if (this.breakIterator != null) {
            this.bib2gls.debug(this.bib2gls.getMessage("message.break.points", string2));
        }
        CollationKey collationKey = this.collator.getCollationKey(string2);
        bib2GlsEntry.setCollationKey(collationKey);
        if (this.bib2gls.useGroupField() && string2.length() > 0 && bib2GlsEntry.getFieldValue("group") == null) {
            String string3;
            Object object2;
            if (this.collator instanceof RuleBasedCollator) {
                String string4;
                String string5;
                GlsResource glsResource;
                GroupTitle groupTitle;
                CollationElementIterator collationElementIterator = ((RuleBasedCollator)this.collator).getCollationElementIterator(string2);
                int n = collationElementIterator.next();
                int n2 = collationElementIterator.getOffset();
                int n3 = 0;
                while (n == 0) {
                    n3 = n2;
                    n = collationElementIterator.next();
                    n2 = collationElementIterator.getOffset();
                }
                int n4 = 0;
                if (n == -1) {
                    this.bib2gls.debug(this.bib2gls.getMessage("message.no.collation.element", string2));
                    if (this.collator.getStrength() == 0) {
                        object2 = Normalizer.normalize(string2, Normalizer.Form.NFD);
                        object2 = ((String)object2).replaceAll("\\p{M}", "");
                        collationElementIterator = ((RuleBasedCollator)this.collator).getCollationElementIterator((String)object2);
                        n = collationElementIterator.next();
                        n2 = collationElementIterator.getOffset();
                    } else {
                        n4 = string2.codePointAt(0);
                        n2 = Character.charCount(n4);
                        object2 = string2;
                        n = n4;
                    }
                    object = object2 = ((String)object2).substring(0, n2);
                } else {
                    object = object2 = string2.substring(n3, n2 == 0 ? 1 : n2);
                    int n5 = this.collator.getStrength();
                    this.collator.setStrength(0);
                    String string6 = Normalizer.normalize(((String)object2).toLowerCase(), Normalizer.Form.NFD);
                    string6 = string6.replaceAll("\\p{M}", "");
                    if (this.collator.compare((String)object2, string6) == 0) {
                        object = string6;
                    }
                    this.collator.setStrength(n5);
                }
                if (!((String)object).isEmpty()) {
                    n4 = ((String)object).codePointAt(0);
                }
                if ((string3 = this.bib2gls.getMessageIfExists(String.format("grouptitle.case.%s", object))) != null) {
                    object = string3;
                    n4 = Character.toTitleCase(n4);
                } else if (Character.isAlphabetic(n4)) {
                    int n6 = Character.toTitleCase(n4);
                    object = n6 > 65535 ? String.format("%c%c%s", Character.valueOf(Character.highSurrogate(n6)), Character.valueOf(Character.lowSurrogate(n6)), ((String)object).substring(Character.charCount(n4)).toLowerCase()) : String.format("%c%s", n6, ((String)object).substring(Character.charCount(n4)).toLowerCase());
                    n4 = n6;
                }
                if (Character.isAlphabetic(n4)) {
                    if (this.collator.getStrength() != 0) {
                        n = n4;
                    }
                    if ((groupTitle = (glsResource = this.bib2gls.getCurrentResource()).getGroupTitle(bib2GlsEntry, n)) == null) {
                        groupTitle = new GroupTitle((String)object, (String)object2, n, glsResource.getType(bib2GlsEntry));
                        glsResource.putGroupTitle(groupTitle);
                        string5 = groupTitle.toString();
                    } else {
                        string4 = glsResource.getType(bib2GlsEntry);
                        string5 = groupTitle.format((String)object2);
                        if (groupTitle.getTitle().matches(".*[^\\p{ASCII}].*") && ((String)object).matches("\\p{ASCII}+")) {
                            groupTitle.setTitle((String)object);
                        }
                    }
                    bib2GlsEntry.putField("group", String.format("\\%s%s", groupTitle.getCsLabelName(), string5));
                } else {
                    if (((String)object2).equals("\\") || ((String)object2).equals("{") || ((String)object2).equals("}")) {
                        object2 = "\\char`\\" + (String)object2;
                    }
                    if ((groupTitle = (glsResource = this.bib2gls.getCurrentResource()).getGroupTitle(bib2GlsEntry, n)) == null) {
                        string4 = glsResource.getType(bib2GlsEntry);
                        groupTitle = new OtherGroupTitle((String)object2, n, string4);
                        glsResource.putGroupTitle(groupTitle);
                        string5 = groupTitle.toString();
                    } else {
                        string5 = groupTitle.format((String)object2);
                    }
                    bib2GlsEntry.putField("group", String.format("\\%s%s", groupTitle.getCsLabelName(), string5));
                }
            } else {
                int n = string2.codePointAt(0);
                String string7 = n > 65535 ? String.format("%c%c", Character.valueOf(Character.highSurrogate(n)), Character.valueOf(Character.lowSurrogate(n))) : String.format("%c", n);
                if (Character.isAlphabetic(n)) {
                    String string8;
                    object = string7.toUpperCase();
                    int n7 = ((String)object).codePointAt(0);
                    GlsResource glsResource = this.bib2gls.getCurrentResource();
                    object2 = glsResource.getGroupTitle(bib2GlsEntry, n7);
                    if (object2 == null) {
                        object2 = new GroupTitle((String)object, string7, n7, glsResource.getType(bib2GlsEntry));
                        glsResource.putGroupTitle((GroupTitle)object2);
                        string8 = ((GroupTitle)object2).toString();
                    } else {
                        string3 = glsResource.getType(bib2GlsEntry);
                        string8 = String.format("{%s}{%s}{%d}{%s}", ((GroupTitle)object2).getTitle(), string7, n7, string3 == null ? "" : string3);
                    }
                    bib2GlsEntry.putField("group", String.format("\\bibglslettergroup%s", string8));
                } else {
                    if (string7.equals("\\") || string7.equals("{") || string7.equals("}")) {
                        string7 = "\\char`\\" + string7;
                    }
                    GlsResource glsResource = this.bib2gls.getCurrentResource();
                    String string9 = glsResource.getType(bib2GlsEntry);
                    bib2GlsEntry.putField("group", String.format("\\bibglsothergroup{%s}{%X}{%s}", string7, n, string9 == null ? "" : string9));
                }
            }
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            byte[] byArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray = collationKey.toByteArray()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(by);
            }
            if (object == null) {
                this.bib2gls.verbose(String.format("%s -> '%s' [%s]", string, string2, stringBuilder));
            } else {
                this.bib2gls.verbose(String.format("%s -> '%s' (%s) [%s]", string, string2, object, stringBuilder));
            }
        }
        return string2;
    }

    @Override
    public int compare(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        if (this.bib2gls.getCurrentResource().flattenSort()) {
            return bib2GlsEntry.getCollationKey().compareTo(bib2GlsEntry2.getCollationKey());
        }
        int n = bib2GlsEntry.getHierarchyCount();
        int n2 = bib2GlsEntry2.getHierarchyCount();
        int n3 = Integer.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Bib2GlsEntry bib2GlsEntry3 = bib2GlsEntry.getHierarchyElement(i);
            Bib2GlsEntry bib2GlsEntry4 = bib2GlsEntry2.getHierarchyElement(i);
            int n4 = bib2GlsEntry3.getCollationKey().compareTo(bib2GlsEntry4.getCollationKey());
            if (this.bib2gls.getDebugLevel() > 1) {
                this.bib2gls.logAndPrintMessage(String.format("%s %c %s", bib2GlsEntry3.getFieldValue("sort"), Character.valueOf((char)(n4 == 0 ? 61 : (n4 < 0 ? 60 : 62))), bib2GlsEntry4.getFieldValue("sort")));
            }
            if (n4 == 0) continue;
            return n4;
        }
        return n == n2 ? 0 : (n < n2 ? -1 : 1);
    }

    public Collator getCollator() {
        return this.collator;
    }

    public void sortEntries() throws Bib2GlsException {
        this.bib2gls.debug(this.bib2gls.getMessage("message.setting.sort", this.collator.getStrength(), this.collator.getDecomposition()));
        for (Bib2GlsEntry bib2GlsEntry : this.entries) {
            bib2GlsEntry.updateHierarchy(this.entries);
            this.updateSortValue(bib2GlsEntry, this.entries);
        }
        this.entries.sort(this);
    }

    public CharSequence breakPoints(String string) {
        if (this.breakIterator == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.breakIterator.setText(string);
        int n = this.breakIterator.first();
        int n2 = this.breakIterator.next();
        while (n2 != -1) {
            String string2 = string.substring(n, n2);
            if (Character.isLetterOrDigit(string2.charAt(0))) {
                stringBuffer.append(string2);
                stringBuffer.append(this.breakPointMarker);
            }
            n = n2;
            n2 = this.breakIterator.next();
        }
        return stringBuffer;
    }
}

