/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class RecentViewList
implements PropertyChangeListener {
    private List<String> tcIdList = new ArrayList<String>(20);
    private Map<String, Reference<TopComponent>> tcCache = new HashMap<String, Reference<TopComponent>>(20);

    public RecentViewList(WindowManager windowManager) {
        windowManager.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public TopComponent[] getTopComponents() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(this.tcIdList.size());
        WindowManager windowManager = WindowManager.getDefault();
        for (int i = 0; i < this.tcIdList.size(); ++i) {
            String string = this.tcIdList.get(i);
            TopComponent topComponent = null;
            Reference<TopComponent> reference = this.tcCache.get(string);
            if (null != reference) {
                topComponent = reference.get();
            }
            if (null == topComponent && null != (topComponent = windowManager.findTopComponent(string))) {
                this.tcCache.put(string, new WeakReference<TopComponent>(topComponent));
            }
            if (topComponent == null || !topComponent.isOpened()) continue;
            arrayList.add(topComponent);
        }
        return arrayList.toArray(new TopComponent[arrayList.size()]);
    }

    public String[] getTopComponentIDs() {
        return this.tcIdList.toArray(new String[this.tcIdList.size()]);
    }

    public void setTopComponents(String[] stringArray) {
        this.tcIdList.clear();
        this.tcIdList.addAll(Arrays.asList(stringArray));
        this.tcCache.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        if ("activated".equals(propertyChangeEvent.getPropertyName()) && (topComponent = (TopComponent)propertyChangeEvent.getNewValue()) != null) {
            String string = WindowManager.getDefault().findTopComponentID(topComponent);
            this.tcIdList.remove(string);
            this.tcIdList.add(0, string);
            this.fillList(TopComponent.getRegistry().getOpened());
        }
    }

    private void fillList(Set<TopComponent> set) {
        this.tcCache.clear();
        WindowManager windowManager = WindowManager.getDefault();
        for (TopComponent topComponent : set) {
            String string = windowManager.findTopComponentID(topComponent);
            if (!this.tcIdList.contains(string)) {
                if (this.tcIdList.size() > 1) {
                    this.tcIdList.add(1, string);
                } else {
                    this.tcIdList.add(string);
                }
            }
            this.tcCache.put(string, new WeakReference<TopComponent>(topComponent));
        }
    }
}

