/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.internal;

import java.text.BreakIterator;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import joptsimple.internal.Strings;

public class Column {
    static final Comparator BY_HEIGHT = new Comparator(){

        public int compare(Object first, Object second) {
            int secondHeight;
            int firstHeight = ((Column)first).height();
            if (firstHeight < (secondHeight = ((Column)second).height())) {
                return -1;
            }
            return firstHeight == secondHeight ? 0 : 1;
        }
    };
    private final String header;
    private final List data;
    private int width;
    private int height;

    Column(String header, int width) {
        this.header = header;
        this.data = new LinkedList();
        this.width = Math.max(width, header.length());
        this.height = 0;
    }

    int addCells(Object cellCandidate) {
        int originalHeight = this.height;
        String source = String.valueOf(cellCandidate).trim();
        BreakIterator words = BreakIterator.getLineInstance(Locale.US);
        words.setText(source);
        StringBuffer nextCell = new StringBuffer();
        int start = words.first();
        int end = words.next();
        while (end != -1) {
            nextCell = this.processNextWord(source, nextCell, start, end);
            start = end;
            end = words.next();
        }
        if (nextCell.length() > 0) {
            this.addCell(nextCell.toString());
        }
        return this.height - originalHeight;
    }

    private StringBuffer processNextWord(String source, StringBuffer nextCell, int start, int end) {
        StringBuffer augmented = nextCell;
        String word = source.substring(start, end);
        if (augmented.length() + word.length() > this.width) {
            this.addCell(augmented.toString());
            augmented = new StringBuffer("  ").append(word);
        } else {
            augmented.append(word);
        }
        return augmented;
    }

    void addCell(String newCell) {
        this.data.add(newCell);
        ++this.height;
    }

    void writeHeaderOn(StringBuffer buffer, boolean appendSpace) {
        buffer.append(this.header).append(Strings.repeat(' ', this.width - this.header.length()));
        if (appendSpace) {
            buffer.append(' ');
        }
    }

    void writeSeparatorOn(StringBuffer buffer, boolean appendSpace) {
        buffer.append(Strings.repeat('-', this.header.length())).append(Strings.repeat(' ', this.width - this.header.length()));
        if (appendSpace) {
            buffer.append(' ');
        }
    }

    void writeCellOn(int index, StringBuffer buffer, boolean appendSpace) {
        if (index < this.data.size()) {
            String item = (String)this.data.get(index);
            buffer.append(item).append(Strings.repeat(' ', this.width - item.length()));
            if (appendSpace) {
                buffer.append(' ');
            }
        }
    }

    int height() {
        return this.height;
    }
}

