/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ExponentiallyWeightedMovingAverage;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class ResponseCollectorService
extends AbstractComponent
implements ClusterStateListener {
    private static final double ALPHA = 0.3;
    private final ConcurrentMap<String, NodeStatistics> nodeIdToStats = ConcurrentCollections.newConcurrentMap();

    public ResponseCollectorService(Settings settings, ClusterService clusterService) {
        super(settings);
        clusterService.addListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                this.removeNode(removedNode.getId());
            }
        }
    }

    void removeNode(String nodeId) {
        this.nodeIdToStats.remove(nodeId);
    }

    public void addNodeStatistics(String nodeId, int queueSize, long responseTimeNanos, long avgServiceTimeNanos) {
        NodeStatistics nodeStats = (NodeStatistics)this.nodeIdToStats.get(nodeId);
        this.nodeIdToStats.compute(nodeId, (id, ns) -> {
            if (ns == null) {
                ExponentiallyWeightedMovingAverage queueEWMA = new ExponentiallyWeightedMovingAverage(0.3, queueSize);
                ExponentiallyWeightedMovingAverage responseEWMA = new ExponentiallyWeightedMovingAverage(0.3, responseTimeNanos);
                NodeStatistics newStats = new NodeStatistics(nodeId, queueEWMA, responseEWMA, avgServiceTimeNanos);
                return newStats;
            }
            ns.queueSize.addValue(queueSize);
            ns.responseTime.addValue(responseTimeNanos);
            ns.serviceTime = avgServiceTimeNanos;
            return ns;
        });
    }

    public Map<String, ComputedNodeStats> getAllNodeStatistics() {
        HashMap<String, ComputedNodeStats> nodeStats = new HashMap<String, ComputedNodeStats>(this.nodeIdToStats.size());
        this.nodeIdToStats.forEach((k, v) -> nodeStats.put((String)k, new ComputedNodeStats((NodeStatistics)v)));
        return nodeStats;
    }

    private static class NodeStatistics {
        final String nodeId;
        final ExponentiallyWeightedMovingAverage queueSize;
        final ExponentiallyWeightedMovingAverage responseTime;
        double serviceTime;

        NodeStatistics(String nodeId, ExponentiallyWeightedMovingAverage queueSizeEWMA, ExponentiallyWeightedMovingAverage responseTimeEWMA, double serviceTimeEWMA) {
            this.nodeId = nodeId;
            this.queueSize = queueSizeEWMA;
            this.responseTime = responseTimeEWMA;
            this.serviceTime = serviceTimeEWMA;
        }
    }

    public static class ComputedNodeStats {
        public final String nodeId;
        public final double queueSize;
        public final double responseTime;
        public final double serviceTime;

        ComputedNodeStats(NodeStatistics nodeStats) {
            this.nodeId = nodeStats.nodeId;
            this.queueSize = nodeStats.queueSize.getAverage();
            this.responseTime = nodeStats.responseTime.getAverage();
            this.serviceTime = nodeStats.serviceTime;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ComputedNodeStats[");
            sb.append(this.nodeId).append("](");
            sb.append("queue: ").append(this.queueSize);
            sb.append(", response time: ").append(this.responseTime);
            sb.append(", service time: ").append(this.serviceTime);
            sb.append(")");
            return sb.toString();
        }
    }
}

