/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.BestBucketsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public abstract class AggregatorBase
extends Aggregator {
    public static final int DEFAULT_WEIGHT = 5120;
    protected final String name;
    protected final Aggregator parent;
    protected final SearchContext context;
    private final Map<String, Object> metaData;
    protected final Aggregator[] subAggregators;
    protected BucketCollector collectableSubAggregators;
    private Map<String, Aggregator> subAggregatorbyName;
    private DeferringBucketCollector recordingWrapper;
    private final List<PipelineAggregator> pipelineAggregators;
    private final CircuitBreakerService breakerService;
    private long requestBytesUsed;

    protected AggregatorBase(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        this.name = name;
        this.pipelineAggregators = pipelineAggregators;
        this.metaData = metaData;
        this.parent = parent;
        this.context = context;
        this.breakerService = context.bigArrays().breakerService();
        assert (factories != null) : "sub-factories provided to BucketAggregator must not be null, use AggragatorFactories.EMPTY instead";
        this.subAggregators = factories.createSubAggregators(this);
        context.addReleasable(this, SearchContext.Lifetime.PHASE);
        this.collectableSubAggregators = new BucketCollector(){

            void badState() {
                throw new QueryPhaseExecutionException(AggregatorBase.this.context, "preCollection not called on new Aggregator before use", null);
            }

            @Override
            public LeafBucketCollector getLeafCollector(LeafReaderContext reader) {
                this.badState();
                assert (false);
                return null;
            }

            @Override
            public void preCollection() throws IOException {
                this.badState();
            }

            @Override
            public void postCollection() throws IOException {
                this.badState();
            }

            public boolean needsScores() {
                this.badState();
                return false;
            }
        };
        this.addRequestCircuitBreakerBytes(5120L);
    }

    protected long addRequestCircuitBreakerBytes(long bytes) {
        if (bytes > 0L) {
            this.breakerService.getBreaker("request").addEstimateBytesAndMaybeBreak(bytes, "<agg [" + this.name + "]>");
        } else {
            this.breakerService.getBreaker("request").addWithoutBreaking(bytes);
        }
        this.requestBytesUsed += bytes;
        return this.requestBytesUsed;
    }

    public boolean needsScores() {
        for (Aggregator agg : this.subAggregators) {
            if (!agg.needsScores()) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> metaData() {
        return this.metaData;
    }

    public List<PipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    protected abstract LeafBucketCollector getLeafCollector(LeafReaderContext var1, LeafBucketCollector var2) throws IOException;

    @Override
    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
        return this.getLeafCollector(ctx, sub);
    }

    protected void doPreCollection() throws IOException {
    }

    @Override
    public final void preCollection() throws IOException {
        ArrayList<BucketCollector> collectors = new ArrayList<BucketCollector>();
        ArrayList<BucketCollector> deferredCollectors = new ArrayList<BucketCollector>();
        for (int i = 0; i < this.subAggregators.length; ++i) {
            if (this.shouldDefer(this.subAggregators[i])) {
                if (this.recordingWrapper == null) {
                    this.recordingWrapper = this.getDeferringCollector();
                }
                deferredCollectors.add(this.subAggregators[i]);
                this.subAggregators[i] = this.recordingWrapper.wrap(this.subAggregators[i]);
                continue;
            }
            collectors.add(this.subAggregators[i]);
        }
        if (this.recordingWrapper != null) {
            this.recordingWrapper.setDeferredCollector(deferredCollectors);
            collectors.add(this.recordingWrapper);
        }
        this.collectableSubAggregators = BucketCollector.wrap(collectors);
        this.doPreCollection();
        this.collectableSubAggregators.preCollection();
    }

    public DeferringBucketCollector getDeferringCollector() {
        return new BestBucketsDeferringCollector(this.context());
    }

    protected boolean shouldDefer(Aggregator aggregator) {
        return false;
    }

    protected final void runDeferredCollections(long ... bucketOrds) throws IOException {
        if (this.recordingWrapper != null) {
            this.recordingWrapper.replay(bucketOrds);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Aggregator parent() {
        return this.parent;
    }

    public Aggregator[] subAggregators() {
        return this.subAggregators;
    }

    @Override
    public Aggregator subAggregator(String aggName) {
        if (this.subAggregatorbyName == null) {
            this.subAggregatorbyName = new HashMap<String, Aggregator>(this.subAggregators.length);
            for (int i = 0; i < this.subAggregators.length; ++i) {
                this.subAggregatorbyName.put(this.subAggregators[i].name(), this.subAggregators[i]);
            }
        }
        return this.subAggregatorbyName.get(aggName);
    }

    @Override
    public SearchContext context() {
        return this.context;
    }

    @Override
    public final void postCollection() throws IOException {
        this.doPostCollection();
        this.collectableSubAggregators.postCollection();
    }

    @Override
    public void close() {
        try {
            this.doClose();
        }
        finally {
            this.breakerService.getBreaker("request").addWithoutBreaking(-this.requestBytesUsed);
        }
    }

    protected void doClose() {
    }

    protected void doPostCollection() throws IOException {
    }

    protected final InternalAggregations buildEmptySubAggregations() {
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        for (Aggregator aggregator : this.subAggregators) {
            aggs.add(aggregator.buildEmptyAggregation());
        }
        return new InternalAggregations((List<InternalAggregation>)aggs);
    }

    public String toString() {
        return this.name;
    }
}

