/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview.attributeview;

import freemind.main.Resources;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.AttributeController;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.AttributeTableLayoutModel;
import freemind.modes.attributes.AttributeTableModel;
import freemind.modes.attributes.ColumnWidthChangeEvent;
import freemind.modes.attributes.ColumnWidthChangeListener;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.attributeview.AttributeTableCellRenderer;
import freemind.view.mindmapview.attributeview.AttributeTableModelDecoratorAdapter;
import freemind.view.mindmapview.attributeview.AttributeView;
import freemind.view.mindmapview.attributeview.ExtendedAttributeTableModelDecorator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class AttributeTable
extends JTable
implements ColumnWidthChangeListener {
    private static final int MAX_HEIGTH = 300;
    private static final int MAX_WIDTH = 600;
    private static MyFocusListener focusListener = new MyFocusListener();
    private static MouseListener componentListener = new HeaderMouseListener();
    private int highRowIndex = 0;
    private static ComboBoxModel defaultComboBoxModel = null;
    private static AttributeTableCellRenderer dtcr = new AttributeTableCellRenderer();
    private AttributeView attributeView;
    private static final int EXTRA_HEIGHT = 4;
    private static final float TABLE_ROW_HEIGHT = 4.0f;
    private static final Dimension prefHeaderSize = new Dimension(1, 8);
    private static Logger mLogger = null;

    AttributeTable(AttributeView attributeView) {
        if (mLogger == null) {
            mLogger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.attributeView = attributeView;
        this.addFocusListener(focusListener);
        MindMapNode model = attributeView.getNodeView().getModel();
        AttributeController attributeController = model.getMap().getRegistry().getModeController().getAttributeController();
        if (attributeController != null) {
            this.getTableHeader().addMouseListener(componentListener);
        } else {
            this.getTableHeader().setResizingAllowed(false);
        }
        this.setModel(attributeView.getCurrentAttributeTableModel());
        this.updateFontSize(this, 1.0f);
        this.updateColumnWidths();
        this.setAutoResizeMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setPreferredSize(prefHeaderSize);
        int h = this.getRowHeight();
        this.updateRowHeights();
        this.setRowSelectionAllowed(false);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        String text = this.getValueAt(row, column).toString();
        dtcr.setText(text);
        int prefWidth = AttributeTable.dtcr.getPreferredSize().width;
        int width = this.getColumnModel().getColumn(column).getWidth();
        if (prefWidth > width) {
            dtcr.setToolTipText(text);
        } else {
            dtcr.setToolTipText(null);
        }
        return dtcr;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        JComboBox comboBox = new JComboBox();
        DefaultCellEditor dce = new DefaultCellEditor(comboBox);
        return dce;
    }

    @Override
    public Component prepareEditor(TableCellEditor tce, int row, int col) {
        ComboBoxModel model;
        JComboBox comboBox = (JComboBox)((DefaultCellEditor)tce).getComponent();
        MindMapNode node = this.getAttributeTableModel().getNode();
        AttributeRegistry attributes = node.getMap().getRegistry().getAttributes();
        switch (col) {
            case 0: {
                model = attributes.getComboBoxModel();
                comboBox.setEditable(!attributes.isRestricted());
                break;
            }
            case 1: {
                String attrName = this.getAttributeTableModel().getValueAt(row, 0).toString();
                model = attributes.getDefaultComboBoxModel((Comparable)((Object)attrName));
                comboBox.setEditable(!attributes.isRestricted(attrName));
                break;
            }
            default: {
                model = AttributeTable.getDefaultComboBoxModel();
            }
        }
        comboBox.setModel(model);
        model.setSelectedItem(this.getValueAt(row, col));
        comboBox.addFocusListener(focusListener);
        comboBox.getEditor().getEditorComponent().addFocusListener(focusListener);
        Component editor = super.prepareEditor(tce, row, col);
        this.updateFontSize(editor, this.getZoom());
        return editor;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (!this.isValid()) {
            this.validate();
        }
        float zoom = this.getZoom();
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.min((int)(600.0f * zoom), dimension.width);
        dimension.height = Math.min((int)(300.0f * zoom) - this.getTableHeaderHeight(), dimension.height);
        return dimension;
    }

    static ComboBoxModel getDefaultComboBoxModel() {
        if (defaultComboBoxModel == null) {
            defaultComboBoxModel = new DefaultComboBoxModel();
        }
        return defaultComboBoxModel;
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return;
        }
        if (rowIndex >= rowCount) {
            rowIndex = 0;
            columnIndex = 0;
        }
        this.changeSelectedRowHeight(rowIndex);
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    private void changeSelectedRowHeight(int rowIndex) {
        if (this.highRowIndex != rowIndex) {
            int h;
            if (this.highRowIndex < this.getRowCount()) {
                h = this.getRowHeight(this.highRowIndex);
                this.setRowHeight(this.highRowIndex, h - 4);
            }
            h = this.getRowHeight(rowIndex);
            this.setRowHeight(rowIndex, h + 4);
            this.highRowIndex = rowIndex;
        }
    }

    void updateAttributeTable() {
        this.updateFontSize(this, 1.0f);
        this.updateRowHeights();
        this.updateColumnWidths();
    }

    private void updateColumnWidths() {
        float zoom = this.getZoom();
        for (int i = 0; i < 2; ++i) {
            int width = (int)((float)this.getAttributeTableModel().getColumnWidth(i) * zoom);
            this.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
    }

    private void updateRowHeights() {
        int i;
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return;
        }
        int constHeight = this.getTableHeaderHeight() + 4;
        float zoom = this.getZoom();
        float fontSize = this.getFontSize();
        float tableRowHeight = fontSize + zoom * 4.0f;
        int newHeight = (int)((tableRowHeight * (float)rowCount + (zoom - 1.0f) * (float)constHeight) / (float)rowCount);
        if (newHeight < 1) {
            newHeight = 1;
        }
        int highRowsNumber = (int)((tableRowHeight - (float)newHeight) * (float)rowCount);
        for (i = 0; i < highRowsNumber; ++i) {
            this.setRowHeight(i, 1 + newHeight + (i == this.highRowIndex ? 4 : 0));
        }
        for (i = highRowsNumber; i < rowCount; ++i) {
            this.setRowHeight(i, newHeight + (i == this.highRowIndex ? 4 : 0));
        }
    }

    int getTableHeaderHeight() {
        JTableHeader tableHeader = this.getTableHeader();
        return tableHeader != null ? tableHeader.getPreferredSize().height : 0;
    }

    private void updateFontSize(Component c, float zoom) {
        float newFontSize;
        float oldFontSize;
        Font font = c.getFont();
        if (font != null && (oldFontSize = font.getSize2D()) != (newFontSize = this.getFontSize() * zoom)) {
            font = font.deriveFont(newFontSize);
            c.setFont(font);
        }
    }

    float getZoom() {
        return this.attributeView.getMapView().getZoom();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.getParent() == null) {
            return;
        }
        if (e.getType() == -1 && e.getFirstRow() == this.highRowIndex && e.getFirstRow() == this.getRowCount() && e.getFirstRow() != 0) {
            this.changeSelection(e.getFirstRow() - 1, 0, false, false);
        } else {
            this.updateRowHeights();
        }
        MapView map = this.getAttributeView().getNodeView().getMap();
        this.getParent().getParent().invalidate();
        map.getModel().nodeChanged(this.getAttributeView().getNode());
    }

    public void viewRemoved() {
        this.getModel().removeTableModelListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    private float getFontSize() {
        return this.attributeView.getNodeView().getModel().getMap().getRegistry().getAttributes().getFontSize();
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
    }

    private void removeListenerFromEditor() {
        JComboBox comboBox = (JComboBox)this.getEditorComponent();
        comboBox.removeFocusListener(focusListener);
        comboBox.getEditor().getEditorComponent().removeFocusListener(focusListener);
        comboBox.setModel(new DefaultComboBoxModel());
    }

    @Override
    public void removeEditor() {
        this.removeListenerFromEditor();
        this.getAttributeTableModel().editingCanceled();
        super.removeEditor();
    }

    public AttributeTableModelDecoratorAdapter getAttributeTableModel() {
        return (AttributeTableModelDecoratorAdapter)this.getModel();
    }

    public AttributeView getAttributeView() {
        return this.attributeView;
    }

    public void setOptimalColumnWidths() {
        Component comp = null;
        int cellWidth = 0;
        int maxCellWidth = 2 * (int)Math.ceil(this.getFontSize() + 4.0f);
        for (int col = 0; col < 2; ++col) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                comp = dtcr.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                cellWidth = comp.getPreferredSize().width;
                maxCellWidth = Math.max(cellWidth, maxCellWidth);
            }
            this.getAttributeTableModel().setColumnWidth(col, maxCellWidth + 1);
        }
    }

    public void insertRow(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                return;
            }
            model.insertRow(row);
            this.changeSelection(row, 0, false, false);
            if (this.editCellAt(row, 0)) {
                this.getEditorComponent().requestFocus();
            }
        }
    }

    public void removeRow(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.removeRow(row);
        }
    }

    public void moveRowUp(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.moveRowUp(row);
        }
    }

    public void moveRowDown(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.moveRowDown(row);
        }
    }

    @Override
    public void columnWidthChanged(ColumnWidthChangeEvent event) {
        float zoom = this.getZoom();
        int col = event.getColumnNumber();
        AttributeTableLayoutModel layoutModel = (AttributeTableLayoutModel)event.getSource();
        int width = layoutModel.getColumnWidth(col);
        this.getColumnModel().getColumn(col).setPreferredWidth((int)((float)width * zoom));
        this.getAttributeView().getNode().getMap().nodeChanged(this.getAttributeView().getNode());
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        mLogger.info("AttributeTable.processKeyBinding");
        if (ks.getKeyCode() == 9 && e.getModifiers() == 0 && pressed && this.getSelectedColumn() == 1 && this.getSelectedRow() == this.getRowCount() - 1 && this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            this.insertRow(this.getRowCount());
            return true;
        }
        if (ks.getKeyCode() == 27 && e.getModifiers() == 0 && pressed) {
            this.attributeView.getNodeView().requestFocus();
            return true;
        }
        boolean retValue = super.processKeyBinding(ks, e, condition, pressed);
        if (!retValue && condition == 0 && this.isFocusOwner() && ks.getKeyCode() != 9 && e != null && e.getID() == 401 && !e.isActionKey() && e.getKeyChar() != '\uffff' && 0 == (e.getModifiers() & 0xA)) {
            int leadRow = this.getSelectionModel().getLeadSelectionIndex();
            int leadColumn = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (leadRow != -1 && leadColumn != -1 && !this.isEditing() && !this.editCellAt(leadRow, leadColumn)) {
                return false;
            }
            Component editorComponent = this.getEditorComponent();
            if (editorComponent instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)editorComponent;
                if (comboBox.isEditable()) {
                    ComboBoxEditor editor = comboBox.getEditor();
                    editor.selectAll();
                    KeyEvent keyEv = new KeyEvent(editor.getEditorComponent(), 400, e.getWhen(), e.getModifiers(), 0, e.getKeyChar(), 0);
                    retValue = SwingUtilities.processKeyBindings(keyEv);
                } else {
                    editorComponent.requestFocus();
                    retValue = true;
                }
            }
        }
        if (ks.getKeyCode() == 32) {
            return true;
        }
        return retValue;
    }

    @Override
    public boolean isVisible() {
        return this.attributeView.areAttributesVisible();
    }

    private static class HeaderMouseListener
    extends MouseAdapter {
        private HeaderMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            AttributeTable table = (AttributeTable)header.getTable();
            float zoom = table.attributeView.getMapView().getZoom();
            Dimension preferredScrollableViewportSize = table.getPreferredScrollableViewportSize();
            JViewport port = (JViewport)table.getParent();
            Dimension extentSize = port.getExtentSize();
            if (preferredScrollableViewportSize.width != extentSize.width) {
                AttributeTableModel model = (AttributeTableModel)table.getModel();
                for (int col = 0; col < table.getColumnCount(); ++col) {
                    int currentColumnWidth;
                    int modelColumnWidth = model.getColumnWidth(col);
                    if (modelColumnWidth == (currentColumnWidth = (int)((float)table.getColumnModel().getColumn(col).getWidth() / zoom))) continue;
                    model.setColumnWidth(col, currentColumnWidth);
                }
            }
        }
    }

    private static class MyFocusListener
    implements FocusListener {
        private AttributeTable focusedTable;

        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            Component source = (Component)event.getSource();
            Component oppositeComponent = event.getOppositeComponent();
            this.focusedTable = source instanceof AttributeTable ? (AttributeTable)source : (AttributeTable)SwingUtilities.getAncestorOfClass(AttributeTable.class, source);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NodeView viewer;
                    Container newNodeViewInFocus;
                    if (MyFocusListener.this.focusedTable != null && (newNodeViewInFocus = SwingUtilities.getAncestorOfClass(NodeView.class, MyFocusListener.this.focusedTable)) != null && (viewer = (NodeView)newNodeViewInFocus) != viewer.getMap().getSelected()) {
                        viewer.getMap().selectAsTheOnlyOneSelected(viewer);
                    }
                }
            });
        }

        @Override
        public void focusLost(FocusEvent event) {
            Component oppositeComponent = event.getOppositeComponent();
            Container newTable = SwingUtilities.getAncestorOfClass(AttributeTable.class, oppositeComponent);
            if (this.focusedTable != null && this.focusedTable != newTable) {
                if (this.focusedTable.isEditing()) {
                    this.focusedTable.getCellEditor().stopCellEditing();
                }
                if (!this.focusedTable.attributeView.isPopupShown()) {
                    AttributeView attributeView = this.focusedTable.getAttributeView();
                    String currentAttributeViewType = attributeView.getNode().getMap().getRegistry().getAttributes().getAttributeViewType();
                    if (attributeView.getViewType() != currentAttributeViewType) {
                        attributeView.stateChanged(null);
                    }
                }
                this.focusedTable = null;
            }
        }
    }
}

