#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cipher-aes
version: 0.2.11
id: cipher-aes-0.2.11-2AcZkDlMC1P6HBBcDalMAM
key: cipher-aes-0.2.11-2AcZkDlMC1P6HBBcDalMAM
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: https://github.com/vincenthz/hs-cipher-aes
synopsis: Fast AES cipher implementation with advanced mode of operations
description:
    Fast AES cipher implementation with advanced mode of operations.
    .
    The modes of operations available are ECB (Electronic code book),
    CBC (Cipher block chaining), CTR (Counter), XTS (XEX with ciphertext stealing),
    GCM (Galois Counter Mode).
    .
    The AES implementation uses AES-NI when available (on x86 and x86-64 architecture),
    but fallback gracefully to a software C implementation.
    .
    The software implementation uses S-Boxes, which might suffer for cache timing issues.
    However do notes that most other known software implementations, including very popular
    one (openssl, gnutls) also uses similar implementation. If it matters for your
    case, you should make sure you have AES-NI available, or you'\''ll need to use a different
    implementation.
    .
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Crypto.Cipher.AES
abi: 230281f6557b6ddbde4bf7ed493d7136
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/cipher-aes-0.2.11
library-dirs: /usr/lib/ghc-8.2.2/site-local/cipher-aes-0.2.11
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/cipher-aes-0.2.11
hs-libraries: HScipher-aes-0.2.11-2AcZkDlMC1P6HBBcDalMAM
depends:
    base-4.10.1.0 bytestring-0.10.8.2
    byteable-0.1.1-4PLPgH6a2E14oN7yL5y3oL
    securemem-0.1.9-Fud1DULXvMOHw02g3KRNM4
    crypto-cipher-types-0.0.9-9WtBN8k9BzdI44CmPyyhPW
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             byteable-0.1.1-4PLPgH6a2E14oN7yL5y3oL=d7caed3dfdc2cc9400ff9a46cbe7296d
             securemem-0.1.9-Fud1DULXvMOHw02g3KRNM4=cd0b1257e86886c9e7da2f187e279c79
             crypto-cipher-types-0.0.9-9WtBN8k9BzdI44CmPyyhPW=aa3c14abbf879e700482b3676ace7dc1
haddock-interfaces: /usr/share/doc/haskell-cipher-aes/html/cipher-aes.haddock
haddock-html: /usr/share/doc/haskell-cipher-aes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

