#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger-lib
version: 1.4
id: hledger-lib-1.4-5WPMpbQ0qy5Bw2mnMyvHZx
key: hledger-lib-1.4-5WPMpbQ0qy5Bw2mnMyvHZx
license: GPL-3
maintainer: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Core data types, parsers and functionality for the hledger accounting tools
description:
    This is a reusable library containing hledger'\''s core functionality.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance
author: Simon Michael <simon@joyful.com>
exposed: True
indefinite: False
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.AutoTransaction
    Hledger.Data.Commodity Hledger.Data.Dates Hledger.Data.Journal
    Hledger.Data.Ledger Hledger.Data.MarketPrice Hledger.Data.Period
    Hledger.Data.Posting Hledger.Data.RawOptions
    Hledger.Data.StringFormat Hledger.Data.Timeclock
    Hledger.Data.Transaction Hledger.Data.Types Hledger.Query
    Hledger.Read Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.JournalReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.BalanceHistoryReport Hledger.Reports.BalanceReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReports
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.TransactionsReports Hledger.Utils
    Hledger.Utils.Color Hledger.Utils.Debug Hledger.Utils.Parse
    Hledger.Utils.Regex Hledger.Utils.String Hledger.Utils.Test
    Hledger.Utils.Text Hledger.Utils.Tree Hledger.Utils.UTF8IOCompat
    Text.Megaparsec.Compat
hidden-modules: Paths_hledger_lib
abi: 6bfd84bf39ce72a503d414f8bb0f0264
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/hledger-lib-1.4
library-dirs: /usr/lib/ghc-8.2.2/site-local/hledger-lib-1.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/hledger-lib-1.4
hs-libraries: HShledger-lib-1.4-5WPMpbQ0qy5Bw2mnMyvHZx
depends:
    base-4.10.1.0 base-compat-0.9.3-915GC5pH10BBmcMnCvMsPA
    ansi-terminal-0.6.3.1-LwW7QlDDdfVDOUh8Avykfz array-0.5.2.0
    blaze-markup-0.8.0.0-KhGWK8j3xIT2gHtdkKPmyu bytestring-0.10.8.2
    cmdargs-0.10.18-6bkRWEoIaWqEtqIB64CQNf containers-0.5.10.2
    csv-0.1.2-DF8z6jUOfpiBCBTUDP7ddT
    data-default-0.7.1.1-FICujruwzSN8grhdf3Hr65
    Decimal-0.4.2-7mRD3xJAgOuJ0IazPguQMz deepseq-1.4.3.0
    directory-1.3.0.2 filepath-1.4.1.2
    hashtables-1.2.2.1-D96UtOZkClK2Kw64wd465
    megaparsec-6.2.0-87wSKD4PSdEGjaKKZiAzSm
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    old-time-1.1.0.3-46BMzRKZrT477y0C8mrrus
    parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1
    pretty-show-1.6.13-Kr7jKj0IStAHwpp9cTcOWv
    regex-tdfa-1.2.2-LXrPID2GWRYz5rkILVGL8
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7
    split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj time-1.8.0.2
    transformers-0.5.2.0 uglymemo-0.1.0.1-1Sek1g9jwwELZwNwbCGwJf
    utf8-string-1.0.1.1-7sQ7eR5H5ED7poickls5aO
    HUnit-1.6.0.0-AX6otQL79amDimk89yA6v4
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             base-compat-0.9.3-915GC5pH10BBmcMnCvMsPA=b23a246a62afd271167dd1ea1b77583b
             ansi-terminal-0.6.3.1-LwW7QlDDdfVDOUh8Avykfz=c4fcb4e64dfe3f3339acd03e710c93da
             array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             blaze-markup-0.8.0.0-KhGWK8j3xIT2gHtdkKPmyu=63159b929711dfedc567b0fafce4aed8
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             cmdargs-0.10.18-6bkRWEoIaWqEtqIB64CQNf=e6b3dbed0c04b55cd444ac7f9ac16c8c
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             csv-0.1.2-DF8z6jUOfpiBCBTUDP7ddT=c8be1ffd4ebf4503e020c87d7967bc83
             data-default-0.7.1.1-FICujruwzSN8grhdf3Hr65=f057e993f72fa1f980dd728ed8010ca1
             Decimal-0.4.2-7mRD3xJAgOuJ0IazPguQMz=de8c82ad77055bd7d0dbe23bf25446e3
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             hashtables-1.2.2.1-D96UtOZkClK2Kw64wd465=48247cff909dde2103c0a9bf3fcb8ec8
             megaparsec-6.2.0-87wSKD4PSdEGjaKKZiAzSm=1c3881587b2cc4d5fbf09a3258b65bd3
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             old-time-1.1.0.3-46BMzRKZrT477y0C8mrrus=3a4f708e3a8313990a7ddaa44eed9995
             parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1=893424ff0bd1ccfdf429c25df7ce2aa4
             pretty-show-1.6.13-Kr7jKj0IStAHwpp9cTcOWv=1f320bbbefd1b43c93900ea66b044933
             regex-tdfa-1.2.2-LXrPID2GWRYz5rkILVGL8=e1619b316a6b2dcb983f330c43208f5f
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7=d64b81e3ed8022aca04423ee7b330679
             split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy=797cd4cd973bcc2d6f301fd097dd3406
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             uglymemo-0.1.0.1-1Sek1g9jwwELZwNwbCGwJf=06fc737510867c1fe7f6851c4d2bd556
             utf8-string-1.0.1.1-7sQ7eR5H5ED7poickls5aO=4a40da384793deade7b4b9c9224acdb7
             HUnit-1.6.0.0-AX6otQL79amDimk89yA6v4=cc02d4bbc4678b779cddf8743bb71eea
haddock-interfaces: /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html: /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

