#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: HTTP
version: 4000.3.8
id: HTTP-4000.3.8-70yj9si8NQ0BnGc3e5cTlD
key: HTTP-4000.3.8-70yj9si8NQ0BnGc3e5cTlD
license: BSD3
maintainer: Ganesh Sittampalam <ganesh@earth.li>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
    .
    __Note:__ This package does not support HTTPS connections.
    If you need HTTPS, take a look at the following packages:
    .
    * <http://hackage.haskell.org/package/http-streams http-streams>
    .
    * <http://hackage.haskell.org/package/http-client http-client> (in combination with
    <http://hackage.haskell.org/package/http-client-tls http-client-tls>)
    .
    * <http://hackage.haskell.org/package/req req>
    .
    * <http://hackage.haskell.org/package/wreq wreq>
    .
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
indefinite: False
exposed-modules:
    Network.Browser Network.BufferType Network.HTTP Network.HTTP.Auth
    Network.HTTP.Base Network.HTTP.Cookie Network.HTTP.HandleStream
    Network.HTTP.Headers Network.HTTP.Proxy Network.HTTP.Stream
    Network.Stream Network.StreamDebugger Network.StreamSocket
    Network.TCP
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
abi: fbd892b8309e03b702d9dabb39b57f67
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/HTTP-4000.3.8
library-dirs: /usr/lib/ghc-8.2.2/site-local/HTTP-4000.3.8
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/HTTP-4000.3.8
hs-libraries: HSHTTP-4000.3.8-70yj9si8NQ0BnGc3e5cTlD
depends:
    base-4.10.1.0 parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1 array-0.5.2.0
    bytestring-0.10.8.2 time-1.8.0.2 mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    network-uri-2.6.1.0-LYYrYvUJy87zSaoB2hpvT
    network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1=893424ff0bd1ccfdf429c25df7ce2aa4
             array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             network-uri-2.6.1.0-LYYrYvUJy87zSaoB2hpvT=0b326ed8cea6aef4683ed7796a7691a6
             network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP=a333d9df3290e5924c2ef4f5f4b24781
haddock-interfaces: /usr/share/doc/haskell-http/html/HTTP.haddock
haddock-html: /usr/share/doc/haskell-http/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

