#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-term
version: 1.2.2
id: tamarin-prover-term-1.2.2-5ZIwASq9hPF5TnD9D6b20Z
key: tamarin-prover-term-1.2.2-5ZIwASq9hPF5TnD9D6b20Z
license: GPL
copyright: Benedikt Schmidt, Simon Meier, ETH Zurich, 2010-2012
maintainer: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>
homepage: http://www.infsec.ethz.ch/research/software/tamarin
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.
category: Theorem Provers
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>
exposed: True
indefinite: False
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm
hidden-modules: Term.Term Term.Term.Classes Term.Term.Raw
                Term.Term.FunctionSymbols Term.Narrowing.Narrow
                Term.Substitution.SubstVFree Term.Substitution.SubstVFresh
abi: 60cf43fd4e535dd49dacede95b257afa
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/tamarin-prover-term-1.2.2
library-dirs: /usr/lib/ghc-8.2.2/site-local/tamarin-prover-term-1.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/tamarin-prover-term-1.2.2
hs-libraries: HStamarin-prover-term-1.2.2-5ZIwASq9hPF5TnD9D6b20Z
depends:
    HUnit-1.6.0.0-AX6otQL79amDimk89yA6v4
    attoparsec-0.13.2.0-1AORA640dG8HmlrlyiwzkH base-4.10.1.0
    binary-0.8.5.1 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 dlist-0.8.0.3-3sLvqWTqZxIC2tgTx4QBVJ
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH process-1.6.1.0
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    tamarin-prover-utils-1.2.2-29rprtoxIif8oIayhAyrJZ
abi-depends: HUnit-1.6.0.0-AX6otQL79amDimk89yA6v4=cc02d4bbc4678b779cddf8743bb71eea
             attoparsec-0.13.2.0-1AORA640dG8HmlrlyiwzkH=166a433e56e808d42a86e30017dad920
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             dlist-0.8.0.3-3sLvqWTqZxIC2tgTx4QBVJ=478549693a66e61496f47353d337a8f9
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             tamarin-prover-utils-1.2.2-29rprtoxIif8oIayhAyrJZ=b788d5f5d829b9cdab72c705751492a0
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

