#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.4.0
id: tls-1.4.0-4FXnb0YAyOYGMZrfsM2P1M
key: tls-1.4.0-4FXnb0YAyOYGMZrfsM2P1M
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.IES
                Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
abi: 902734af033d6644136bfa4dbec0c414
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/tls-1.4.0
library-dirs: /usr/lib/ghc-8.2.2/site-local/tls-1.4.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/tls-1.4.0
hs-libraries: HStls-1.4.0-4FXnb0YAyOYGMZrfsM2P1M
depends:
    base-4.10.1.0 mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH transformers-0.5.2.0
    cereal-0.5.4.0-HHG4trmDAey7tG5Rc3nyML bytestring-0.10.8.2
    data-default-class-0.1.2.0-ImBMrJK18PFLLtssITDnZ5
    memory-0.14.9-AQUrr5dF0nV994F583HdFJ
    cryptonite-0.24-EPbi0P2shFM6674a2VpBE9
    asn1-types-0.3.2-CX7tV4W3EAa3oKd8ACm2MK
    asn1-encoding-0.9.5-EJqYFW8FAIXE6XsDARhXmf
    x509-1.7.2-3BTw6RFLwvUAEE2vpmDae6
    x509-store-1.6.5-LCbrEaSgvo1J30od7Iz8ng
    x509-validation-1.6.9-3gYibDsrkZb2uwlDZ33E5W
    async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn
    network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             cereal-0.5.4.0-HHG4trmDAey7tG5Rc3nyML=ed459ea038cbdb253abe2c011f65c556
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             data-default-class-0.1.2.0-ImBMrJK18PFLLtssITDnZ5=59d0190781dd74e9cf2161eb5998f2f1
             memory-0.14.9-AQUrr5dF0nV994F583HdFJ=008982010396ecb5861316ba65cfe759
             cryptonite-0.24-EPbi0P2shFM6674a2VpBE9=ad6e802a541fc646db7950285912403a
             asn1-types-0.3.2-CX7tV4W3EAa3oKd8ACm2MK=f780ead905f212b13ca5d42eea39d7ba
             asn1-encoding-0.9.5-EJqYFW8FAIXE6XsDARhXmf=a5951d4bdbc3025fe147f5781181d12f
             x509-1.7.2-3BTw6RFLwvUAEE2vpmDae6=1b3c6fa43bdb9156755a2eda9f144c94
             x509-store-1.6.5-LCbrEaSgvo1J30od7Iz8ng=5e1c240251b3c0e5ef6b721371276e72
             x509-validation-1.6.9-3gYibDsrkZb2uwlDZ33E5W=9d24b1d6bc9d054f5851967573826f80
             async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn=7d406f0044aa7af43d5b6fcf63e521db
             network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP=a333d9df3290e5924c2ef4f5f4b24781
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

