#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: turtle
version: 1.4.5
id: turtle-1.4.5-3ZJPMNSw22ICzaCtjprioy
key: turtle-1.4.5-3ZJPMNSw22ICzaCtjprioy
license: BSD3
copyright: 2015 Gabriel Gonzalez
maintainer: Gabriel439@gmail.com
synopsis: Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.
    .
    Features include:
    .
    * Batteries included: Command an extended suite of predefined utilities
    .
    * Interoperability: You can still run external shell commands
    .
    * Portability: Works on Windows, OS X, and Linux
    .
    * Exception safety: Safely acquire and release resources
    .
    * Streaming: Transform or fold command output in constant space
    .
    * Patterns: Use typed regular expressions that can parse structured values
    .
    * Formatting: Type-safe @printf@-style text formatting
    .
    * Modern: Supports @text@ and @system-filepath@
    .
    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide
    .
    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.
category: System
author: Gabriel Gonzalez
exposed: True
indefinite: False
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial
hidden-modules: Turtle.Internal
abi: c038bb57d583151e8c87c825d20fad82
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/turtle-1.4.5
library-dirs: /usr/lib/ghc-8.2.2/site-local/turtle-1.4.5
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/turtle-1.4.5
hs-libraries: HSturtle-1.4.5-3ZJPMNSw22ICzaCtjprioy
depends:
    base-4.10.1.0 ansi-wl-pprint-0.6.8.1-87Vp1rYcKt73B49zrIk7Nn
    async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn bytestring-0.10.8.2
    clock-0.7.2-HOYfHHJ3W4Qjx04GjA0Jy containers-0.5.10.2
    directory-1.3.0.2 foldl-1.3.5-1aLyAQekRmeENbOJHGThi0
    hostname-1.0-5lbge5b93EG9eAOssUn3b3
    managed-1.0.5-JwPhzVcLbN636Xkdl8jbtP process-1.6.1.0
    semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7
    system-filepath-0.4.13.4-3TqvCgOYxDiENfvMWRc65v
    system-fileio-0.3.16.3-7auWLrqM4CK5UlNdO6310V
    stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw
    temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj time-1.8.0.2
    transformers-0.5.2.0
    optparse-applicative-0.14.0.0-15HrL1rhEUQ8kuSXm7AxHM
    optional-args-1.0.1-LSWDxtgvZU5I6qCMWlU5eh
    unix-compat-0.4.3.1-9X6l1OQmDE7ClflprogzfQ unix-2.7.2.2
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             ansi-wl-pprint-0.6.8.1-87Vp1rYcKt73B49zrIk7Nn=e6a9bf0a855d772264f9d0892180e936
             async-2.1.1.1-K5IvYqkVegLI7CBS6i3gtn=7d406f0044aa7af43d5b6fcf63e521db
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             clock-0.7.2-HOYfHHJ3W4Qjx04GjA0Jy=01c820dbfea727c150599d4a04cd30b6
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             foldl-1.3.5-1aLyAQekRmeENbOJHGThi0=218d8ec317134c38473fe255aa278db0
             hostname-1.0-5lbge5b93EG9eAOssUn3b3=1e26ea54c76847e41751db7c657115b7
             managed-1.0.5-JwPhzVcLbN636Xkdl8jbtP=6ed7064eb493038acf26295ab9a83f62
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             semigroups-0.18.3-3aCIuYG4ID286XaN6MuQu7=d64b81e3ed8022aca04423ee7b330679
             system-filepath-0.4.13.4-3TqvCgOYxDiENfvMWRc65v=46f8a2f6c459dced3e9b89b04618141a
             system-fileio-0.3.16.3-7auWLrqM4CK5UlNdO6310V=93faff2d1018c6e2891dce96321c7472
             stm-2.4.4.1-E6EjE1bszQZJ9orPdUNxjw=63c518eabfb1b430d925fb35cc544a7c
             temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro=b8bff4b84b25638f1f5ef8924bbd6e32
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             optparse-applicative-0.14.0.0-15HrL1rhEUQ8kuSXm7AxHM=398f88a60fc236b476dc7bccc88aa8e8
             optional-args-1.0.1-LSWDxtgvZU5I6qCMWlU5eh=11c4264fde1df1d08becc4d4450a8587
             unix-compat-0.4.3.1-9X6l1OQmDE7ClflprogzfQ=345a389dfaa60cac4e76e74a938e5e3c
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
haddock-interfaces: /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html: /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

