#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger
version: 1.4
id: hledger-1.4-EeuECGvaNtf2VWFWsz4qsP
key: hledger-1.4-EeuECGvaNtf2VWFWsz4qsP
license: GPL-3
maintainer: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Command-line interface for the hledger accounting tool
description:
    This is hledger'\''s command-line interface.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance, Console
author: Simon Michael <simon@joyful.com>
exposed: True
indefinite: False
exposed-modules:
    Hledger.Cli Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Checkdates
    Hledger.Cli.Commands.Checkdupes Hledger.Cli.Commands.Equity
    Hledger.Cli.Commands.Help Hledger.Cli.Commands.Import
    Hledger.Cli.Commands.Incomestatement Hledger.Cli.Commands.Prices
    Hledger.Cli.Commands.Print Hledger.Cli.Commands.Printunique
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Registermatch
    Hledger.Cli.Commands.Rewrite Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Main Hledger.Cli.Utils
    Hledger.Cli.Version Text.Tabular.AsciiWide
hidden-modules: Paths_hledger
abi: 3777c28a44d1536887a9a30d1fbae66e
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/hledger-1.4
library-dirs: /usr/lib/ghc-8.2.2/site-local/hledger-1.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/hledger
hs-libraries: HShledger-1.4-EeuECGvaNtf2VWFWsz4qsP
depends:
    base-4.10.1.0 base-compat-0.9.3-915GC5pH10BBmcMnCvMsPA
    ansi-terminal-0.6.3.1-LwW7QlDDdfVDOUh8Avykfz directory-1.3.0.2
    file-embed-0.0.10.1-dHJWrXRvu59h2yyMVhlwG filepath-1.4.1.2
    here-1.2.11-Gc20UgbfKqXXZkXNiW2kr
    pretty-show-1.6.13-Kr7jKj0IStAHwpp9cTcOWv process-1.6.1.0
    shakespeare-2.0.14.1-8lllG01WUkK3AEC9ayBhyv
    temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro
    tabular-0.2.2.7-5b7MGmRWrPsD9aeDanGUHj time-1.8.0.2
    utility-ht-0.0.14-1SDJ0BtW7GoAaRrxZT3hIq
    hledger-lib-1.4-5WPMpbQ0qy5Bw2mnMyvHZx bytestring-0.10.8.2
    containers-0.5.10.2
    unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV
    cmdargs-0.10.18-6bkRWEoIaWqEtqIB64CQNf
    csv-0.1.2-DF8z6jUOfpiBCBTUDP7ddT
    data-default-0.7.1.1-FICujruwzSN8grhdf3Hr65
    Diff-0.3.4-L9SyyiDrARPC15xQMKbgIG
    hashable-1.2.6.1-9ZXmUmZR8Ja1wkFjzrwxTy haskeline-0.7.4.0
    HUnit-1.6.0.0-AX6otQL79amDimk89yA6v4
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    old-time-1.1.0.3-46BMzRKZrT477y0C8mrrus
    megaparsec-6.2.0-87wSKD4PSdEGjaKKZiAzSm
    regex-tdfa-1.2.2-LXrPID2GWRYz5rkILVGL8
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy transformers-0.5.2.0
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj
    utf8-string-1.0.1.1-7sQ7eR5H5ED7poickls5aO
    wizards-1.0.2-7jdryUlVLPnLlRRmKn7qK0 terminfo-0.4.1.0
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             base-compat-0.9.3-915GC5pH10BBmcMnCvMsPA=b23a246a62afd271167dd1ea1b77583b
             ansi-terminal-0.6.3.1-LwW7QlDDdfVDOUh8Avykfz=c4fcb4e64dfe3f3339acd03e710c93da
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             file-embed-0.0.10.1-dHJWrXRvu59h2yyMVhlwG=290747ebe676cf9f89313503a2e38e54
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             here-1.2.11-Gc20UgbfKqXXZkXNiW2kr=af4d48a936b5f2e47524db63a62c5eee
             pretty-show-1.6.13-Kr7jKj0IStAHwpp9cTcOWv=1f320bbbefd1b43c93900ea66b044933
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             shakespeare-2.0.14.1-8lllG01WUkK3AEC9ayBhyv=4a471b07556a2d8ccd34f27a0593ec1a
             temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro=b8bff4b84b25638f1f5ef8924bbd6e32
             tabular-0.2.2.7-5b7MGmRWrPsD9aeDanGUHj=0afa087b5db75b06ce622fb82da2710e
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             utility-ht-0.0.14-1SDJ0BtW7GoAaRrxZT3hIq=0362a121972f0b40c9fe893b813ad252
             hledger-lib-1.4-5WPMpbQ0qy5Bw2mnMyvHZx=6bfd84bf39ce72a503d414f8bb0f0264
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV=db9131d5548eea6d7a3eab9f0d172004
             cmdargs-0.10.18-6bkRWEoIaWqEtqIB64CQNf=e6b3dbed0c04b55cd444ac7f9ac16c8c
             csv-0.1.2-DF8z6jUOfpiBCBTUDP7ddT=c8be1ffd4ebf4503e020c87d7967bc83
             data-default-0.7.1.1-FICujruwzSN8grhdf3Hr65=f057e993f72fa1f980dd728ed8010ca1
             Diff-0.3.4-L9SyyiDrARPC15xQMKbgIG=fa15f70edd791f66a59264b7aea15224
             hashable-1.2.6.1-9ZXmUmZR8Ja1wkFjzrwxTy=6e4b4a70e10d525b7db51e3859aab169
             haskeline-0.7.4.0=1141a9f24dba7d57fb2023df1fd20c51
             HUnit-1.6.0.0-AX6otQL79amDimk89yA6v4=cc02d4bbc4678b779cddf8743bb71eea
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             old-time-1.1.0.3-46BMzRKZrT477y0C8mrrus=3a4f708e3a8313990a7ddaa44eed9995
             megaparsec-6.2.0-87wSKD4PSdEGjaKKZiAzSm=1c3881587b2cc4d5fbf09a3258b65bd3
             regex-tdfa-1.2.2-LXrPID2GWRYz5rkILVGL8=e1619b316a6b2dcb983f330c43208f5f
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy=797cd4cd973bcc2d6f301fd097dd3406
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             utf8-string-1.0.1.1-7sQ7eR5H5ED7poickls5aO=4a40da384793deade7b4b9c9224acdb7
             wizards-1.0.2-7jdryUlVLPnLlRRmKn7qK0=33910d29b870b84adfaa6d6d01727211
             terminfo-0.4.1.0=acb5ccd00d0581773cc2733d8844bf64
haddock-interfaces: /usr/share/doc/hledger/html/hledger.haddock
haddock-html: /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

