/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmCompressedTask
extends DownloadOsmTask {
    private static final String PATTERN_COMPRESS = "https?://.*/.*\\.osm.(gz|bz2?|zip)";

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_COMPRESS};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download Compressed OSM", new Object[0]);
    }

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean newLayer, final String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadOsmTask.DownloadTask(newLayer, (OsmServerReader)new OsmServerLocationReader(url), progressMonitor){

            @Override
            protected DataSet parseDataSet() throws OsmTransferException {
                ProgressMonitor subTaskMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                if (url.matches("https?://.*/.*\\.osm.bz2?")) {
                    return this.reader.parseOsmBzip2(subTaskMonitor);
                }
                if (url.matches("https?://.*/.*\\.osm.gz")) {
                    return this.reader.parseOsmGzip(subTaskMonitor);
                }
                return this.reader.parseOsmZip(subTaskMonitor);
            }
        };
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osm.(gz|bz2?|zip))", url);
        return MainApplication.worker.submit(this.downloadTask);
    }
}

