/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.util.Objects;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.SignpostAdapters;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class OAuthParameters {
    public static final String DEFAULT_JOSM_CONSUMER_KEY = "F7zPYlVCqE2BUH9Hr4SsWZSOnrKjpug1EgqkbsSb";
    public static final String DEFAULT_JOSM_CONSUMER_SECRET = "rIkjpPcBNkMQxrqzcOvOC4RRuYupYr7k8mfP13H5";
    private final String consumerKey;
    private final String consumerSecret;
    private final String requestTokenUrl;
    private final String accessTokenUrl;
    private final String authoriseUrl;
    private final String osmLoginUrl;
    private final String osmLogoutUrl;

    public static OAuthParameters createDefault() {
        return OAuthParameters.createDefault(null);
    }

    public static OAuthParameters createDefault(String apiUrl) {
        String serverUrl;
        String consumerSecret;
        String consumerKey;
        if (!Utils.isValidUrl(apiUrl)) {
            apiUrl = null;
        }
        if (apiUrl != null && !"https://api.openstreetmap.org/api".equals(apiUrl)) {
            consumerKey = "";
            consumerSecret = "";
            serverUrl = apiUrl.replaceAll("/api$", "");
        } else {
            consumerKey = DEFAULT_JOSM_CONSUMER_KEY;
            consumerSecret = DEFAULT_JOSM_CONSUMER_SECRET;
            serverUrl = Main.getOSMWebsite();
        }
        return new OAuthParameters(consumerKey, consumerSecret, serverUrl + "/oauth/request_token", serverUrl + "/oauth/access_token", serverUrl + "/oauth/authorize", serverUrl + "/login", serverUrl + "/logout");
    }

    public static OAuthParameters createFromApiUrl(String apiUrl) {
        OAuthParameters parameters = OAuthParameters.createDefault(apiUrl);
        return new OAuthParameters(Config.getPref().get("oauth.settings.consumer-key", parameters.getConsumerKey()), Config.getPref().get("oauth.settings.consumer-secret", parameters.getConsumerSecret()), Config.getPref().get("oauth.settings.request-token-url", parameters.getRequestTokenUrl()), Config.getPref().get("oauth.settings.access-token-url", parameters.getAccessTokenUrl()), Config.getPref().get("oauth.settings.authorise-url", parameters.getAuthoriseUrl()), Config.getPref().get("oauth.settings.osm-login-url", parameters.getOsmLoginUrl()), Config.getPref().get("oauth.settings.osm-logout-url", parameters.getOsmLogoutUrl()));
    }

    @Deprecated
    public static OAuthParameters createFromPreferences(Preferences pref2) {
        OAuthParameters parameters = OAuthParameters.createDefault(pref2.get("osm-server.url"));
        return new OAuthParameters(pref2.get("oauth.settings.consumer-key", parameters.getConsumerKey()), pref2.get("oauth.settings.consumer-secret", parameters.getConsumerSecret()), pref2.get("oauth.settings.request-token-url", parameters.getRequestTokenUrl()), pref2.get("oauth.settings.access-token-url", parameters.getAccessTokenUrl()), pref2.get("oauth.settings.authorise-url", parameters.getAuthoriseUrl()), pref2.get("oauth.settings.osm-login-url", parameters.getOsmLoginUrl()), pref2.get("oauth.settings.osm-logout-url", parameters.getOsmLogoutUrl()));
    }

    public void rememberPreferences() {
        Config.getPref().put("oauth.settings.consumer-key", this.getConsumerKey());
        Config.getPref().put("oauth.settings.consumer-secret", this.getConsumerSecret());
        Config.getPref().put("oauth.settings.request-token-url", this.getRequestTokenUrl());
        Config.getPref().put("oauth.settings.access-token-url", this.getAccessTokenUrl());
        Config.getPref().put("oauth.settings.authorise-url", this.getAuthoriseUrl());
        Config.getPref().put("oauth.settings.osm-login-url", this.getOsmLoginUrl());
        Config.getPref().put("oauth.settings.osm-logout-url", this.getOsmLogoutUrl());
    }

    @Deprecated
    public void rememberPreferences(Preferences pref2) {
        CheckParameterUtil.ensureParameterNotNull(pref2, "pref");
        pref2.put("oauth.settings.consumer-key", this.getConsumerKey());
        pref2.put("oauth.settings.consumer-secret", this.getConsumerSecret());
        pref2.put("oauth.settings.request-token-url", this.getRequestTokenUrl());
        pref2.put("oauth.settings.access-token-url", this.getAccessTokenUrl());
        pref2.put("oauth.settings.authorise-url", this.getAuthoriseUrl());
        pref2.put("oauth.settings.osm-login-url", this.getOsmLoginUrl());
        pref2.put("oauth.settings.osm-logout-url", this.getOsmLogoutUrl());
    }

    public OAuthParameters(String consumerKey, String consumerSecret, String requestTokenUrl, String accessTokenUrl, String authoriseUrl, String osmLoginUrl, String osmLogoutUrl) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.requestTokenUrl = requestTokenUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.authoriseUrl = authoriseUrl;
        this.osmLoginUrl = osmLoginUrl;
        this.osmLogoutUrl = osmLogoutUrl;
    }

    public OAuthParameters(OAuthParameters other) {
        CheckParameterUtil.ensureParameterNotNull(other, "other");
        this.consumerKey = other.consumerKey;
        this.consumerSecret = other.consumerSecret;
        this.accessTokenUrl = other.accessTokenUrl;
        this.requestTokenUrl = other.requestTokenUrl;
        this.authoriseUrl = other.authoriseUrl;
        this.osmLoginUrl = other.osmLoginUrl;
        this.osmLogoutUrl = other.osmLogoutUrl;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getAuthoriseUrl() {
        return this.authoriseUrl;
    }

    public String getOsmLoginUrl() {
        return this.osmLoginUrl;
    }

    public String getOsmLogoutUrl() {
        return this.osmLogoutUrl;
    }

    public OAuthConsumer buildConsumer() {
        return new SignpostAdapters.OAuthConsumer(this.consumerKey, this.consumerSecret);
    }

    public OAuthProvider buildProvider(OAuthConsumer consumer) {
        CheckParameterUtil.ensureParameterNotNull(consumer, "consumer");
        return new SignpostAdapters.OAuthProvider(this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthParameters that = (OAuthParameters)o;
        return Objects.equals(this.consumerKey, that.consumerKey) && Objects.equals(this.consumerSecret, that.consumerSecret) && Objects.equals(this.requestTokenUrl, that.requestTokenUrl) && Objects.equals(this.accessTokenUrl, that.accessTokenUrl) && Objects.equals(this.authoriseUrl, that.authoriseUrl) && Objects.equals(this.osmLoginUrl, that.osmLoginUrl) && Objects.equals(this.osmLogoutUrl, that.osmLogoutUrl);
    }

    public int hashCode() {
        return Objects.hash(this.consumerKey, this.consumerSecret, this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl, this.osmLoginUrl, this.osmLogoutUrl);
    }
}

