/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class MainPanel
extends JPanel {
    private MapFrame map;
    private GettingStarted gettingStarted;
    private final CopyOnWriteArrayList<MapFrameListener> mapFrameListeners = new CopyOnWriteArrayList();
    private final transient MainLayerManager layerManager;

    public MainPanel(MainLayerManager layerManager) {
        super(new BorderLayout());
        this.layerManager = layerManager;
    }

    protected synchronized void updateContent(boolean showMap) {
        GuiHelper.assertCallFromEdt();
        MapFrame old = this.map;
        if (old != null && showMap) {
            return;
        }
        this.setVisible(false);
        this.removeAll();
        if (old != null) {
            old.destroy();
        }
        if (showMap) {
            this.map = this.createNewMapFrame();
        } else {
            Main.map = this.map = null;
            MainApplication.map = this.map;
            this.add((Component)this.getGettingStarted(), "Center");
        }
        this.setVisible(true);
        if (old == null && !showMap) {
            return;
        }
        for (MapFrameListener listener : this.mapFrameListeners) {
            listener.mapFrameInitialized(old, this.map);
        }
        if (this.map == null && PleaseWaitProgressMonitor.getCurrent() != null) {
            PleaseWaitProgressMonitor.getCurrent().showForegroundDialog();
        }
    }

    private MapFrame createNewMapFrame() {
        MapFrame mapFrame;
        Main.map = mapFrame = new MapFrame(null);
        MainApplication.map = mapFrame;
        mapFrame.fillPanel(this);
        List<Layer> layers = MainApplication.getLayerManager().getLayers();
        if (!layers.isEmpty()) {
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction(), layers.get(0));
        }
        mapFrame.initializeDialogsPane();
        mapFrame.setVisible(true);
        return mapFrame;
    }

    public synchronized boolean addAndFireMapFrameListener(MapFrameListener listener) {
        boolean changed = this.addMapFrameListener(listener);
        if (changed && this.map != null) {
            listener.mapFrameInitialized(null, this.map);
        }
        return changed;
    }

    public boolean addMapFrameListener(MapFrameListener listener) {
        return listener != null && this.mapFrameListeners.add(listener);
    }

    public boolean removeMapFrameListener(MapFrameListener listener) {
        return listener != null && this.mapFrameListeners.remove(listener);
    }

    public synchronized GettingStarted getGettingStarted() {
        if (this.gettingStarted == null) {
            this.gettingStarted = new GettingStarted();
        }
        return this.gettingStarted;
    }

    public void reAddListeners() {
        this.layerManager.addLayerAvailabilityListener(new MainLayerManager.LayerAvailabilityListener(){

            @Override
            public void beforeFirstLayerAdded(MainLayerManager.LayerAvailabilityEvent e) {
                MainPanel.this.updateContent(true);
            }

            @Override
            public void afterLastLayerRemoved(MainLayerManager.LayerAvailabilityEvent e) {
                MainPanel.this.updateContent(false);
            }
        });
        GuiHelper.runInEDTAndWait(() -> this.updateContent(!this.layerManager.getLayers().isEmpty()));
    }
}

