/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class InspectPrimitiveDataText {
    private static final String INDENT = "  ";
    private static final char NL = '\n';
    private final StringBuilder s = new StringBuilder();
    private final DataSet ds;

    InspectPrimitiveDataText(DataSet ds) {
        this.ds = ds;
    }

    private InspectPrimitiveDataText add(String title, String ... values) {
        this.s.append(INDENT).append(title);
        for (String v : values) {
            this.s.append(v);
        }
        this.s.append('\n');
        return this;
    }

    private static String getNameAndId(String name, long id) {
        if (name != null) {
            return name + I18n.tr(" ({0})", Long.toString(id));
        }
        return Long.toString(id);
    }

    public void addPrimitive(OsmPrimitive o) {
        this.addHeadline(o);
        if (o.getDataSet() == null || o.getDataSet().getPrimitiveById(o) == null) {
            this.s.append('\n').append(INDENT).append(I18n.tr("not in data set", new Object[0])).append('\n');
            return;
        }
        if (o.isIncomplete()) {
            this.s.append('\n').append(INDENT).append(I18n.tr("incomplete", new Object[0])).append('\n');
            return;
        }
        this.s.append('\n');
        this.addState(o);
        this.addCommon(o);
        this.addAttributes(o);
        this.addSpecial(o);
        this.addReferrers(this.s, o);
        this.addConflicts(o);
        this.s.append('\n');
    }

    void addHeadline(OsmPrimitive o) {
        this.addType(o);
        this.addNameAndId(o);
    }

    void addType(OsmPrimitive o) {
        if (o instanceof Node) {
            this.s.append(I18n.tr("Node: ", new Object[0]));
        } else if (o instanceof Way) {
            this.s.append(I18n.tr("Way: ", new Object[0]));
        } else if (o instanceof Relation) {
            this.s.append(I18n.tr("Relation: ", new Object[0]));
        }
    }

    void addNameAndId(OsmPrimitive o) {
        String name = o.get("name");
        if (name == null) {
            this.s.append(o.getUniqueId());
        } else {
            this.s.append(InspectPrimitiveDataText.getNameAndId(name, o.getUniqueId()));
        }
    }

    void addState(OsmPrimitive o) {
        String state;
        StringBuilder sb = new StringBuilder(INDENT);
        if (o.isDeleted()) {
            sb.append(I18n.tr("deleted", new Object[0])).append(INDENT);
        }
        if (!o.isVisible()) {
            sb.append(I18n.tr("deleted-on-server", new Object[0])).append(INDENT);
        }
        if (o.isModified()) {
            sb.append(I18n.tr("modified", new Object[0])).append(INDENT);
        }
        if (o.isDisabledAndHidden()) {
            sb.append(I18n.tr("filtered/hidden", new Object[0])).append(INDENT);
        }
        if (o.isDisabled()) {
            sb.append(I18n.tr("filtered/disabled", new Object[0])).append(INDENT);
        }
        if (o.hasDirectionKeys()) {
            if (o.reversedDirection()) {
                sb.append(I18n.tr("has direction keys (reversed)", new Object[0])).append(INDENT);
            } else {
                sb.append(I18n.tr("has direction keys", new Object[0])).append(INDENT);
            }
        }
        if (!(state = sb.toString().trim()).isEmpty()) {
            this.add(I18n.tr("State: ", new Object[0]), sb.toString().trim());
        }
    }

    void addCommon(OsmPrimitive o) {
        this.add(I18n.tr("Data Set: ", new Object[0]), Integer.toHexString(o.getDataSet().hashCode()));
        this.add(I18n.tr("Edited at: ", new Object[0]), o.isTimestampEmpty() ? I18n.tr("<new object>", new Object[0]) : DateUtils.fromTimestamp(o.getRawTimestamp()));
        this.add(I18n.tr("Edited by: ", new Object[0]), o.getUser() == null ? I18n.tr("<new object>", new Object[0]) : InspectPrimitiveDataText.getNameAndId(o.getUser().getName(), o.getUser().getId()));
        this.add(I18n.tr("Version: ", new Object[0]), Integer.toString(o.getVersion()));
        this.add(I18n.tr("In changeset: ", new Object[0]), Integer.toString(o.getChangesetId()));
    }

    void addAttributes(OsmPrimitive o) {
        if (o.hasKeys()) {
            this.add(I18n.tr("Tags: ", new Object[0]), new String[0]);
            for (String key : o.keySet()) {
                this.s.append(INDENT).append(INDENT);
                this.s.append(String.format("\"%s\"=\"%s\"%n", key, o.get(key)));
            }
        }
    }

    void addSpecial(OsmPrimitive o) {
        if (o instanceof Node) {
            this.addCoordinates((Node)o);
        } else if (o instanceof Way) {
            this.addBbox(o);
            this.add(I18n.tr("Centroid: ", new Object[0]), InspectPrimitiveDataText.toStringCSV(", ", Main.getProjection().eastNorth2latlon(Geometry.getCentroid(((Way)o).getNodes()))));
            this.addWayNodes((Way)o);
        } else if (o instanceof Relation) {
            this.addBbox(o);
            this.addRelationMembers((Relation)o);
        }
    }

    void addRelationMembers(Relation r) {
        this.add(I18n.trn("{0} Member: ", "{0} Members: ", r.getMembersCount(), r.getMembersCount()), new String[0]);
        for (RelationMember m : r.getMembers()) {
            this.s.append(INDENT).append(INDENT);
            this.addHeadline(m.getMember());
            this.s.append(I18n.tr(" as \"{0}\"", m.getRole()));
            this.s.append('\n');
        }
    }

    void addWayNodes(Way w) {
        this.add(I18n.tr("{0} Nodes: ", w.getNodesCount()), new String[0]);
        for (Node n : w.getNodes()) {
            this.s.append(INDENT).append(INDENT);
            this.addNameAndId(n);
            this.s.append('\n');
        }
    }

    void addBbox(OsmPrimitive o) {
        BBox bbox = o.getBBox();
        if (bbox != null) {
            this.add(I18n.tr("Bounding box: ", new Object[0]), bbox.toStringCSV(", "));
            EastNorth bottomRigth = bbox.getBottomRight().getEastNorth(Main.getProjection());
            EastNorth topLeft = bbox.getTopLeft().getEastNorth(Main.getProjection());
            this.add(I18n.tr("Bounding box (projected): ", new Object[0]), Double.toString(topLeft.east()), ", ", Double.toString(bottomRigth.north()), ", ", Double.toString(bottomRigth.east()), ", ", Double.toString(topLeft.north()));
            this.add(I18n.tr("Center of bounding box: ", new Object[0]), InspectPrimitiveDataText.toStringCSV(", ", bbox.getCenter()));
        }
    }

    void addCoordinates(Node n) {
        if (n.isLatLonKnown()) {
            this.add(I18n.tr("Coordinates: ", new Object[0]), Double.toString(n.lat()), ", ", Double.toString(n.lon()));
            EastNorth en = n.getEastNorth();
            this.add(I18n.tr("Coordinates (projected): ", new Object[0]), Double.toString(en.east()), ", ", Double.toString(en.north()));
            Pair<Integer, TransverseMercator.Hemisphere> utmZone = TransverseMercator.locateUtmZone(n.getCoor());
            String utmLabel = I18n.tr("UTM Zone", new Object[0]);
            this.add(utmLabel, utmLabel.endsWith(":") ? " " : ": ", Integer.toString((Integer)utmZone.a), ((TransverseMercator.Hemisphere)((Object)utmZone.b)).toString().substring(0, 1));
        }
    }

    void addReferrers(StringBuilder s, OsmPrimitive o) {
        List<OsmPrimitive> refs = o.getReferrers();
        if (!refs.isEmpty()) {
            this.add(I18n.tr("Part of: ", new Object[0]), new String[0]);
            for (OsmPrimitive p : refs) {
                s.append(INDENT).append(INDENT);
                this.addHeadline(p);
                s.append('\n');
            }
        }
    }

    void addConflicts(OsmPrimitive o) {
        Conflict<?> c = this.ds.getConflicts().getConflictForMy(o);
        if (c != null) {
            this.add(I18n.tr("In conflict with: ", new Object[0]), new String[0]);
            this.addNameAndId((OsmPrimitive)c.getTheir());
        }
    }

    private static String toStringCSV(String separator, ILatLon ll) {
        return Utils.join(separator, Arrays.asList(DecimalDegreesCoordinateFormat.INSTANCE.latToString(ll), DecimalDegreesCoordinateFormat.INSTANCE.lonToString(ll)));
    }

    public String toString() {
        return this.s.toString();
    }
}

