/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;

public class MainLayerManager
extends LayerManager {
    private Layer activeLayer;
    private OsmDataLayer editLayer;
    private final List<ActiveLayerChangeListener> activeLayerChangeListeners = new CopyOnWriteArrayList<ActiveLayerChangeListener>();
    private final List<LayerAvailabilityListener> layerAvailabilityListeners = new CopyOnWriteArrayList<LayerAvailabilityListener>();

    public synchronized void addActiveLayerChangeListener(ActiveLayerChangeListener listener) {
        if (this.activeLayerChangeListeners.contains(listener)) {
            throw new IllegalArgumentException("Attempted to add listener that was already in list: " + listener);
        }
        this.activeLayerChangeListeners.add(listener);
    }

    public synchronized void addAndFireActiveLayerChangeListener(ActiveLayerChangeListener listener) {
        this.addActiveLayerChangeListener(listener);
        listener.activeOrEditLayerChanged(new ActiveLayerChangeEvent(this, null, null));
    }

    public synchronized void removeActiveLayerChangeListener(ActiveLayerChangeListener listener) {
        if (!this.activeLayerChangeListeners.contains(listener)) {
            throw new IllegalArgumentException("Attempted to remove listener that was not in list: " + listener);
        }
        this.activeLayerChangeListeners.remove(listener);
    }

    public synchronized void addLayerAvailabilityListener(LayerAvailabilityListener listener) {
        if (!this.layerAvailabilityListeners.add(listener)) {
            throw new IllegalArgumentException("Attempted to add listener that was already in list: " + listener);
        }
    }

    public synchronized void removeLayerAvailabilityListener(LayerAvailabilityListener listener) {
        if (!this.layerAvailabilityListeners.remove(listener)) {
            throw new IllegalArgumentException("Attempted to remove listener that was not in list: " + listener);
        }
    }

    public void setActiveLayer(Layer layer) {
        if (layer instanceof OsmDataLayer && ((OsmDataLayer)layer).isReadOnly()) {
            GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.parent, I18n.tr("Trying to set a read only data layer as edit layer", new Object[0]), I18n.tr("Warning", new Object[0]), 2));
        } else {
            GuiHelper.runInEDTAndWaitWithException(() -> this.realSetActiveLayer(layer));
        }
    }

    protected synchronized void realSetActiveLayer(Layer layer) {
        this.checkContainsLayer(layer);
        this.setActiveLayer(layer, false);
    }

    private void setActiveLayer(Layer layer, boolean forceEditLayerUpdate) {
        ActiveLayerChangeEvent event = new ActiveLayerChangeEvent(this, this.editLayer, this.activeLayer);
        this.activeLayer = layer;
        if (this.activeLayer instanceof OsmDataLayer) {
            this.editLayer = (OsmDataLayer)this.activeLayer;
        } else if (forceEditLayerUpdate) {
            this.editLayer = null;
        }
        this.fireActiveLayerChange(event);
    }

    private void fireActiveLayerChange(ActiveLayerChangeEvent event) {
        GuiHelper.assertCallFromEdt();
        if (event.getPreviousActiveLayer() != this.activeLayer || event.getPreviousEditLayer() != this.editLayer) {
            for (ActiveLayerChangeListener l : this.activeLayerChangeListeners) {
                l.activeOrEditLayerChanged(event);
            }
        }
    }

    @Override
    protected synchronized void realAddLayer(Layer layer, boolean initialZoom) {
        if (this.getLayers().isEmpty()) {
            LayerAvailabilityEvent e = new LayerAvailabilityEvent(this, true);
            for (LayerAvailabilityListener l : this.layerAvailabilityListeners) {
                l.beforeFirstLayerAdded(e);
            }
        }
        super.realAddLayer(layer, initialZoom);
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            this.setActiveLayer(layer);
        }
    }

    @Override
    protected Collection<Layer> realRemoveSingleLayer(Layer layer) {
        if (layer == this.activeLayer || layer == this.editLayer) {
            Layer nextActive = this.suggestNextActiveLayer(layer);
            this.setActiveLayer(nextActive, true);
        }
        Collection<Layer> toDelete = super.realRemoveSingleLayer(layer);
        if (this.getLayers().isEmpty()) {
            LayerAvailabilityEvent e = new LayerAvailabilityEvent(this, false);
            for (LayerAvailabilityListener l : this.layerAvailabilityListeners) {
                l.afterLastLayerRemoved(e);
            }
        }
        return toDelete;
    }

    private Layer suggestNextActiveLayer(Layer except) {
        ArrayList<Layer> layersList = new ArrayList<Layer>(this.getLayers());
        layersList.remove(except);
        for (Layer layer : layersList) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return layer;
        }
        if (!layersList.isEmpty()) {
            return (Layer)layersList.get(0);
        }
        return null;
    }

    public synchronized Layer getActiveLayer() {
        if (this.activeLayer instanceof OsmDataLayer) {
            if (!((OsmDataLayer)this.activeLayer).isReadOnly()) {
                return this.activeLayer;
            }
            return null;
        }
        return this.activeLayer;
    }

    public synchronized OsmDataLayer getEditLayer() {
        if (this.editLayer != null && !this.editLayer.isReadOnly()) {
            return this.editLayer;
        }
        return null;
    }

    public synchronized DataSet getEditDataSet() {
        if (this.editLayer != null) {
            return this.editLayer.data;
        }
        return null;
    }

    public synchronized List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> ret = new ArrayList<Layer>();
        boolean activeLayerDelayed = false;
        List<Layer> layers = this.getLayers();
        ListIterator<Layer> iterator = layers.listIterator(layers.size());
        while (iterator.hasPrevious()) {
            Layer l = iterator.previous();
            if (!l.isVisible()) continue;
            if (l == this.activeLayer && l instanceof OsmDataLayer) {
                activeLayerDelayed = true;
                continue;
            }
            if (activeLayerDelayed && !(l instanceof OsmDataLayer)) {
                ret.add(this.activeLayer);
                activeLayerDelayed = false;
            }
            ret.add(l);
        }
        if (activeLayerDelayed) {
            ret.add(this.activeLayer);
        }
        return ret;
    }

    public void invalidateEditLayer() {
        if (this.editLayer != null) {
            this.editLayer.invalidate();
        }
    }

    @Override
    protected synchronized void realResetState() {
        super.realResetState();
        this.activeLayerChangeListeners.clear();
        this.layerAvailabilityListeners.clear();
    }

    public void prepareLayerForUpload(OsmDataLayer layer) {
        GuiHelper.assertCallFromEdt();
        layer.setReadOnly();
        if (this.editLayer == layer) {
            ActiveLayerChangeEvent activeLayerChangeEvent = new ActiveLayerChangeEvent(this, this.editLayer, this.activeLayer);
            this.editLayer = null;
            this.fireActiveLayerChange(activeLayerChangeEvent);
        }
    }

    public void processLayerAfterUpload(OsmDataLayer layer) {
        GuiHelper.assertCallFromEdt();
        layer.unsetReadOnly();
        if (this.editLayer == null) {
            ActiveLayerChangeEvent layerChangeEvent = new ActiveLayerChangeEvent(this, this.editLayer, this.activeLayer);
            this.editLayer = layer;
            this.fireActiveLayerChange(layerChangeEvent);
        }
    }

    public static interface LayerAvailabilityListener {
        public void beforeFirstLayerAdded(LayerAvailabilityEvent var1);

        public void afterLastLayerRemoved(LayerAvailabilityEvent var1);
    }

    public static class LayerAvailabilityEvent
    extends LayerManager.LayerManagerEvent {
        private final boolean hasLayers;

        LayerAvailabilityEvent(LayerManager source, boolean hasLayers) {
            super(source);
            this.hasLayers = hasLayers;
        }

        public boolean hasLayers() {
            return this.hasLayers;
        }
    }

    public static class ActiveLayerChangeEvent
    extends LayerManager.LayerManagerEvent {
        private final OsmDataLayer previousEditLayer;
        private final Layer previousActiveLayer;

        ActiveLayerChangeEvent(MainLayerManager source, OsmDataLayer previousEditLayer, Layer previousActiveLayer) {
            super(source);
            this.previousEditLayer = previousEditLayer;
            this.previousActiveLayer = previousActiveLayer;
        }

        public OsmDataLayer getPreviousEditLayer() {
            return this.previousEditLayer;
        }

        public Layer getPreviousActiveLayer() {
            return this.previousActiveLayer;
        }

        public DataSet getPreviousEditDataSet() {
            if (this.previousEditLayer != null) {
                return this.previousEditLayer.data;
            }
            return null;
        }

        @Override
        public MainLayerManager getSource() {
            return (MainLayerManager)super.getSource();
        }
    }

    @FunctionalInterface
    public static interface ActiveLayerChangeListener {
        public void activeOrEditLayerChanged(ActiveLayerChangeEvent var1);
    }
}

