/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Arrays;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.gui.mappaint.DividedScale;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.tools.Pair;

public final class StyleCache {
    private static final Storage<StyleCache> internPool = new Storage();
    public static final StyleCache EMPTY_STYLECACHE = new StyleCache().intern();
    private static final int PLAIN = 0;
    private static final int SELECTED = 1;
    private final DividedScale<StyleElementList>[] states = new DividedScale[2];

    private StyleCache(StyleCache sc) {
        this.states[0] = sc.states[0];
        this.states[1] = sc.states[1];
    }

    private StyleCache() {
    }

    public StyleCache put(StyleElementList o, Range r, boolean selected) {
        StyleCache s = new StyleCache(this);
        int idx = StyleCache.getIndex(selected);
        s.states[idx] = Optional.ofNullable(s.states[idx]).orElseGet(DividedScale::new).put(o, r);
        return s.intern();
    }

    public Pair<StyleElementList, Range> getWithRange(double scale, boolean selected) {
        int idx = StyleCache.getIndex(selected);
        if (this.states[idx] == null) {
            return Pair.create(null, Range.ZERO_TO_INFINITY);
        }
        return this.states[idx].getWithRange(scale);
    }

    private static int getIndex(boolean selected) {
        return selected ? 1 : 0;
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.states);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyleCache other = (StyleCache)obj;
        return Arrays.deepEquals(this.states, other.states);
    }

    private StyleCache intern() {
        return internPool.putUnique(this);
    }

    static void clearStyleCachePool() {
        internPool.clear();
    }

    public static int getInternPoolSize() {
        return internPool.size();
    }
}

