/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;

public class AdvancedKeyPressDetector
implements AWTEventListener {
    private final Set<Integer> set = new TreeSet<Integer>();
    private KeyEvent releaseEvent;
    private Timer timer;
    private final List<KeyPressReleaseListener> keyListeners = new CopyOnWriteArrayList<KeyPressReleaseListener>();
    @Deprecated
    private final List<ModifierListener> modifierListeners = new CopyOnWriteArrayList<ModifierListener>();
    private final ListenerList<ModifierExListener> modifierExListeners = ListenerList.create();
    @Deprecated
    private int previousModifiers;
    private int previousModifiersEx;
    private boolean enabled = true;

    public void addKeyListener(KeyPressReleaseListener l) {
        this.keyListeners.add(l);
    }

    @Deprecated
    public void addModifierListener(ModifierListener l) {
        this.modifierListeners.add(l);
    }

    public void addModifierExListener(ModifierExListener l) {
        this.modifierExListeners.addListener(l);
    }

    public void removeKeyListener(KeyPressReleaseListener l) {
        this.keyListeners.remove(l);
    }

    @Deprecated
    public void removeModifierListener(ModifierListener l) {
        this.modifierListeners.remove(l);
    }

    public void removeModifierExListener(ModifierExListener l) {
        this.modifierExListeners.removeListener(l);
    }

    public void register() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Logging.warn(ex);
        }
        this.timer = new Timer(0, e -> {
            this.timer.stop();
            if (this.set.remove(this.releaseEvent.getKeyCode()) && this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                for (KeyPressReleaseListener q : this.keyListeners) {
                    q.doKeyReleased(this.releaseEvent);
                }
            }
        });
    }

    public void unregister() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.set.clear();
        if (!this.keyListeners.isEmpty()) {
            Logging.warn(I18n.tr("Some of the key listeners forgot to remove themselves: {0}", new Object[0]), this.keyListeners.toString());
        }
        if (!this.modifierListeners.isEmpty()) {
            Logging.warn(I18n.tr("Some of the key modifier listeners forgot to remove themselves: {0}", new Object[0]), this.modifierListeners.toString());
        }
        if (this.modifierExListeners.hasListeners()) {
            Logging.warn(I18n.tr("Some of the key modifier listeners forgot to remove themselves: {0}", new Object[0]), this.modifierExListeners.toString());
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Logging.warn(ex);
        }
    }

    private void processKeyEvent(KeyEvent e) {
        if (Logging.isTraceEnabled()) {
            Logging.trace("AdvancedKeyPressDetector enabled={0} => processKeyEvent({1}) from {2}", this.enabled, e, new Exception().getStackTrace()[2]);
        }
        if (e.getID() == 401) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else if (this.set.add(e.getKeyCode()) && this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                for (KeyPressReleaseListener q : this.keyListeners) {
                    Logging.trace("{0} => doKeyPressed({1})", q, e);
                    q.doKeyPressed(e);
                }
            }
        } else if (e.getID() == 402) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                if (this.set.remove(e.getKeyCode()) && this.enabled && AdvancedKeyPressDetector.isFocusInMainWindow()) {
                    for (KeyPressReleaseListener q : this.keyListeners) {
                        Logging.trace("{0} => doKeyReleased({1})", q, e);
                        q.doKeyReleased(e);
                    }
                }
            } else {
                this.releaseEvent = e;
                this.timer.restart();
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        int modifEx;
        if (!(e instanceof KeyEvent)) {
            return;
        }
        KeyEvent ke = (KeyEvent)e;
        int modif = ke.getModifiers();
        if (this.previousModifiers != modif) {
            this.previousModifiers = modif;
            for (ModifierListener m2 : this.modifierListeners) {
                m2.modifiersChanged(modif);
            }
        }
        if (this.previousModifiersEx != (modifEx = ke.getModifiersEx())) {
            this.previousModifiersEx = modifEx;
            this.modifierExListeners.fireEvent(m -> m.modifiersExChanged(modifEx));
        }
        this.processKeyEvent(ke);
    }

    public boolean isKeyPressed(int keyCode) {
        return this.set.contains(keyCode);
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (Logging.isTraceEnabled()) {
            Logging.trace("AdvancedKeyPressDetector enabled={0} from {1}", enabled, new Exception().getStackTrace()[1]);
        }
    }

    private static boolean isFocusInMainWindow() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focused != null && SwingUtilities.getWindowAncestor(focused) instanceof JFrame;
    }
}

