/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarHandler
extends ZipHandler {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    public CoreJarHandler(@NotNull CoreJarFileSystem fileSystem, @NotNull String path2) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "<init>"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "<init>"));
        }
        super(path2);
        this.myFileSystem = fileSystem;
        HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries = new HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile>();
        Map<String, ArchiveHandler.EntryInfo> entriesMap = this.getEntriesMap();
        FactoryMap<CoreJarVirtualFile, List<VirtualFile>> childrenMap = new FactoryMap<CoreJarVirtualFile, List<VirtualFile>>(){

            @Override
            @Nullable
            protected List<VirtualFile> create(CoreJarVirtualFile key) {
                return new ArrayList<VirtualFile>();
            }
        };
        for (ArchiveHandler.EntryInfo info : entriesMap.values()) {
            CoreJarVirtualFile file = this.getOrCreateFile(info, entries);
            VirtualFile parent2 = file.getParent();
            if (parent2 == null) continue;
            ((List)childrenMap.get(parent2)).add(file);
        }
        ArchiveHandler.EntryInfo rootInfo = this.getEntryInfo("");
        this.myRoot = rootInfo != null ? this.getOrCreateFile(rootInfo, entries) : null;
        for (Map.Entry entry : childrenMap.entrySet()) {
            List childList = (List)entry.getValue();
            ((CoreJarVirtualFile)entry.getKey()).setChildren(childList.toArray(VirtualFile.EMPTY_ARRAY));
        }
    }

    @NotNull
    private CoreJarVirtualFile getOrCreateFile(@NotNull ArchiveHandler.EntryInfo info, @NotNull Map<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        CoreJarVirtualFile file = entries.get(info);
        if (file == null) {
            ArchiveHandler.EntryInfo parent2 = info.parent;
            file = new CoreJarVirtualFile(this, info.shortName, info.isDirectory ? -1L : info.length, info.timestamp, parent2 != null ? this.getOrCreateFile(parent2, entries) : null);
            entries.put(info, file);
        }
        CoreJarVirtualFile coreJarVirtualFile = file;
        if (coreJarVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        return coreJarVirtualFile;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String pathInJar) {
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "findFileByPath"));
        }
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    @NotNull
    public CoreJarFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myFileSystem;
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getFileSystem"));
        }
        return coreJarFileSystem;
    }
}

