/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.WalkingState;
import org.jetbrains.annotations.NotNull;

public abstract class PsiWalkingState
extends WalkingState<PsiElement> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiWalkingState");
    private final PsiElementVisitor myVisitor;

    protected PsiWalkingState(@NotNull PsiElementVisitor delegate2) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/PsiWalkingState", "<init>"));
        }
        this(delegate2, PsiTreeGuide.instance);
    }

    protected PsiWalkingState(@NotNull PsiElementVisitor delegate2, @NotNull WalkingState.TreeGuide<PsiElement> guide) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/PsiWalkingState", "<init>"));
        }
        if (guide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guide", "com/intellij/psi/PsiWalkingState", "<init>"));
        }
        super(guide);
        this.myVisitor = delegate2;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiWalkingState", "visit"));
        }
        element.accept(this.myVisitor);
    }

    @Override
    public void elementStarted(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiWalkingState", "elementStarted"));
        }
        if (!this.startedWalking && element instanceof PsiCompiledElement) {
            LOG.error(element + "; Do not use walking visitor inside compiled PSI since getNextSibling() is too slow there");
        }
        super.elementStarted(element);
    }

    private static class PsiTreeGuide
    implements WalkingState.TreeGuide<PsiElement> {
        private static final PsiTreeGuide instance = new PsiTreeGuide();

        private PsiTreeGuide() {
        }

        @Override
        public PsiElement getNextSibling(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiWalkingState$PsiTreeGuide", "getNextSibling"));
            }
            return PsiTreeGuide.checkSanity(element, element.getNextSibling());
        }

        private static PsiElement checkSanity(PsiElement element, PsiElement sibling) {
            if (sibling == PsiUtilCore.NULL_PSI_ELEMENT) {
                throw new PsiInvalidElementAccessException(element, "Sibling of " + element + " is NULL_PSI_ELEMENT");
            }
            return sibling;
        }

        @Override
        public PsiElement getPrevSibling(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiWalkingState$PsiTreeGuide", "getPrevSibling"));
            }
            return PsiTreeGuide.checkSanity(element, element.getPrevSibling());
        }

        @Override
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiWalkingState$PsiTreeGuide", "getFirstChild"));
            }
            return element.getFirstChild();
        }

        @Override
        public PsiElement getParent(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiWalkingState$PsiTreeGuide", "getParent"));
            }
            return element.getParent();
        }
    }
}

