/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

public class SimpleInputBuffer {
    private String sContent;
    private int nIndex;
    private int nLen;

    private static boolean isDigitOrDot(char cChar) {
        return cChar >= '0' && cChar <= '9' || cChar == '.';
    }

    private static boolean isDigitOrDotOrComma(char cChar) {
        return SimpleInputBuffer.isDigitOrDot(cChar) || cChar == ',';
    }

    public SimpleInputBuffer(String sContent) {
        this.sContent = sContent;
        this.nLen = sContent.length();
        this.nIndex = 0;
    }

    public int getIndex() {
        return this.nIndex;
    }

    public boolean atEnd() {
        return this.nIndex >= this.nLen;
    }

    public char peekChar() {
        return this.nIndex < this.nLen ? this.sContent.charAt(this.nIndex) : (char)'\u0000';
    }

    public char peekFollowingChar() {
        return this.nIndex + 1 < this.nLen ? this.sContent.charAt(this.nIndex + 1) : (char)'\u0000';
    }

    public char getChar() {
        return this.nIndex < this.nLen ? this.sContent.charAt(this.nIndex++) : (char)'\u0000';
    }

    public String getIdentifier() {
        int nStart = this.nIndex;
        while (this.nIndex < this.nLen && (Character.isLetter(this.sContent.charAt(this.nIndex)) || SimpleInputBuffer.isDigitOrDot(this.sContent.charAt(this.nIndex)))) {
            ++this.nIndex;
        }
        return this.sContent.substring(nStart, this.nIndex);
    }

    public String getNumber() {
        int nStart = this.nIndex;
        while (this.nIndex < this.nLen && SimpleInputBuffer.isDigitOrDotOrComma(this.sContent.charAt(this.nIndex))) {
            ++this.nIndex;
        }
        return this.sContent.substring(nStart, this.nIndex);
    }

    public String getInteger() {
        int nStart = this.nIndex;
        while (this.nIndex < this.nLen && this.sContent.charAt(this.nIndex) >= '0' && this.sContent.charAt(this.nIndex) <= '9') {
            ++this.nIndex;
        }
        return this.sContent.substring(nStart, this.nIndex);
    }

    public void skipSpaces() {
        while (this.nIndex < this.nLen && this.sContent.charAt(this.nIndex) == ' ') {
            ++this.nIndex;
        }
    }
}

