/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b&\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0015J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/browsers/WebBrowserUrlProvider;", "", "()V", "canHandleElement", "", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "getUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUrls", "", "BrowserException", "Companion", "xml-openapi"})
public abstract class WebBrowserUrlProvider {
    @NotNull
    private static final ExtensionPointName<WebBrowserUrlProvider> EP_NAME;
    public static final Companion Companion;

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        Collection<Url> collection;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            collection = this.getUrls(request);
        }
        catch (BrowserException ignored) {
            return false;
        }
        Collection<Url> urls = collection;
        if (!urls.isEmpty()) {
            request.setResult(urls);
            return true;
        }
        return false;
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile file) throws BrowserException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return null;
    }

    @NotNull
    public Collection<Url> getUrls(@NotNull OpenInBrowserRequest request) throws BrowserException {
        Url url;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        VirtualFile virtualFile2 = request.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            url = this.getUrl(request, it);
        } else {
            url = null;
        }
        return CollectionsKt.listOfNotNull(url);
    }

    static {
        Companion = new Companion(null);
        EP_NAME = ExtensionPointName.create((String)"com.intellij.webBrowserUrlProvider");
    }

    @NotNull
    public static final ExtensionPointName<WebBrowserUrlProvider> getEP_NAME() {
        return Companion.getEP_NAME();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/browsers/WebBrowserUrlProvider$BrowserException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "xml-openapi"})
    public static final class BrowserException
    extends Exception {
        public BrowserException(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R*\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/browsers/WebBrowserUrlProvider$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/ide/browsers/WebBrowserUrlProvider;", "kotlin.jvm.PlatformType", "EP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "xml-openapi"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void EP_NAME$annotations() {
        }

        @NotNull
        public final ExtensionPointName<WebBrowserUrlProvider> getEP_NAME() {
            return EP_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

