/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.PluginId;
import java.awt.event.InputEvent;
import java.util.Comparator;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionManagerEx
extends ActionManager {
    public static ActionManagerEx getInstanceEx() {
        return (ActionManagerEx)ActionManagerEx.getInstance();
    }

    public abstract ActionToolbar createActionToolbar(String var1, @NotNull ActionGroup var2, boolean var3, boolean var4);

    public abstract void fireBeforeActionPerformed(AnAction var1, DataContext var2, AnActionEvent var3);

    public abstract void fireAfterActionPerformed(AnAction var1, DataContext var2, AnActionEvent var3);

    public abstract void fireBeforeEditorTyping(char var1, DataContext var2);

    public abstract String getLastPreformedActionId();

    public abstract String getPrevPreformedActionId();

    @NotNull
    public abstract Comparator<String> getRegistrationOrderComparator();

    @Nullable
    public static KeyStroke getKeyStroke(String s) {
        KeyStroke result = null;
        try {
            result = KeyStroke.getKeyStroke(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null && s != null && s.length() >= 2 && s.charAt(s.length() - 2) == ' ') {
            try {
                String s1 = s.substring(0, s.length() - 1) + Character.toUpperCase(s.charAt(s.length() - 1));
                result = KeyStroke.getKeyStroke(s1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @NotNull
    public abstract String[] getPluginActions(@NotNull PluginId var1);

    public abstract void queueActionPerformedEvent(AnAction var1, DataContext var2, AnActionEvent var3);

    public abstract boolean isActionPopupStackEmpty();

    public abstract boolean isTransparentOnlyActionsUpdateNow();

    public void fireBeforeActionPerformed(String actionId, InputEvent event) {
        AnAction action = this.getAction(actionId);
        if (action != null) {
            AnActionEvent e = AnActionEvent.createFromAnAction(action, event, "unknown", DataManager.getInstance().getDataContext());
            this.fireBeforeActionPerformed(action, DataManager.getInstance().getDataContext(), e);
        }
    }
}

