/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnCleanup;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgCleanup
extends SvnNgOperationRunner<Void, SvnCleanup> {
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        SVNWCContext wcContext;
        if (((SvnCleanup)this.getOperation()).getFirstTarget().isURL()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)((SvnCleanup)this.getOperation()).getFirstTarget().getURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File localAbsPath = ((SvnCleanup)this.getOperation()).getFirstTarget().getFile().getAbsoluteFile();
        if (((SvnCleanup)this.getOperation()).isBreakLocks()) {
            SVNWCDb db = new SVNWCDb();
            wcContext = new SVNWCContext(db, context.getEventHandler());
        } else {
            wcContext = context;
        }
        String[] ignores = wcContext.getOptions().getIgnorePatterns();
        this.doCleanup(localAbsPath, wcContext, Arrays.asList(ignores));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup(File localAbsPath, SVNWCContext wcContext, List<String> ignores) throws SVNException {
        this.cleanup(wcContext, localAbsPath);
        this.sleepForTimestamp();
        if (((SvnCleanup)this.getOperation()).isRemoveUnversionedItems() || ((SvnCleanup)this.getOperation()).isRemoveIgnoredItems() || ((SvnCleanup)this.getOperation()).isIncludeExternals()) {
            CleanupStatusWalk cleanupStatusWalk = new CleanupStatusWalk();
            cleanupStatusWalk.removeUnversionedItems = ((SvnCleanup)this.getOperation()).isRemoveUnversionedItems();
            cleanupStatusWalk.removeIgnoredItems = ((SvnCleanup)this.getOperation()).isRemoveIgnoredItems();
            cleanupStatusWalk.includeExternals = ((SvnCleanup)this.getOperation()).isIncludeExternals();
            cleanupStatusWalk.eventHandler = wcContext.getEventHandler();
            cleanupStatusWalk.wcContext = wcContext;
            cleanupStatusWalk.ignores = ignores;
            cleanupStatusWalk.operation = (SvnCleanup)this.getOperation();
            File lockPath = wcContext.acquireWriteLock(localAbsPath, false, true);
            try {
                SVNStatusEditor17 statusEditor17 = new SVNStatusEditor17(localAbsPath, this.getWcContext(), ((SvnCleanup)this.getOperation()).getOptions(), ((SvnCleanup)this.getOperation()).isRemoveIgnoredItems(), true, SVNDepth.INFINITY, cleanupStatusWalk);
                statusEditor17.walkStatus(localAbsPath, SVNDepth.INFINITY, true, ((SvnCleanup)this.getOperation()).isRemoveIgnoredItems(), true, ignores);
            }
            finally {
                wcContext.releaseWriteLock(lockPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(SVNWCContext wcContext, File localAbsPath) throws SVNException {
        boolean breakLocks = ((SvnCleanup)this.getOperation()).isBreakLocks();
        try {
            if (breakLocks) {
                wcContext.getDb().open(ISVNWCDb.SVNWCDbOpenMode.ReadWrite, null, true, false);
            }
            this.cleanupInternal(wcContext, localAbsPath);
            if (((SvnCleanup)this.getOperation()).isDeleteWCProperties()) {
                wcContext.getDb().clearDavCacheRecursive(localAbsPath);
            }
        }
        finally {
            if (breakLocks) {
                wcContext.getDb().close();
            }
        }
    }

    private int canBeCleaned(SVNWCContext wcContext, File localAbsPath) throws SVNException {
        SVNErrorMessage err;
        int wcFormat = wcContext.checkWC(localAbsPath);
        if (wcFormat == 0) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy directory", (Object)localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (wcFormat < 12) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Log format too old, please use Subversion 1.6 or earlier");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return wcFormat;
    }

    private void cleanupInternal(SVNWCContext wcContext, File localAbsPath) throws SVNException {
        File cleanupWCRoot;
        int wcFormat = this.canBeCleaned(wcContext, localAbsPath);
        wcContext.getDb().obtainWCLock(localAbsPath, -1, ((SvnCleanup)this.getOperation()).isBreakLocks());
        if (wcFormat >= 13) {
            wcContext.wqRun(localAbsPath);
        }
        if ((cleanupWCRoot = wcContext.getDb().getWCRoot(localAbsPath)).equals(localAbsPath) && ((SvnCleanup)this.getOperation()).isVacuumPristines()) {
            SVNWCUtils.admCleanupTmpArea(wcContext, localAbsPath);
            wcContext.getDb().cleanupPristine(localAbsPath);
        }
        SvnNgCleanup.repairTimestamps(wcContext, localAbsPath);
        wcContext.getDb().releaseWCLock(localAbsPath);
    }

    public static void repairTimestamps(SVNWCContext wcContext, File localAbsPath) throws SVNException {
        wcContext.checkCancelled();
        ISVNWCDb.WCDbInfo info = wcContext.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind);
        if (info.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || info.status == ISVNWCDb.SVNWCDbStatus.Deleted || info.status == ISVNWCDb.SVNWCDbStatus.Excluded || info.status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
            return;
        }
        if (info.kind == ISVNWCDb.SVNWCDbKind.File || info.kind == ISVNWCDb.SVNWCDbKind.Symlink) {
            try {
                wcContext.isTextModified(localAbsPath, false);
            }
            catch (SVNException e) {
                SVNDebugLog.getDefaultLog().log(SVNLogType.WC, e, Level.WARNING);
            }
        } else if (info.kind == ISVNWCDb.SVNWCDbKind.Dir) {
            Set<String> children = wcContext.getDb().readChildren(localAbsPath);
            for (String childPath : children) {
                File childAbsPath = SVNFileUtil.createFilePath(localAbsPath, childPath);
                SvnNgCleanup.repairTimestamps(wcContext, childAbsPath);
            }
        }
    }

    private static class CleanupStatusWalk
    implements ISvnObjectReceiver<SvnStatus> {
        private boolean removeUnversionedItems;
        private boolean removeIgnoredItems;
        private boolean includeExternals;
        private SVNWCContext context;
        private ISVNEventHandler eventHandler;
        private SVNWCContext wcContext;
        private List<String> ignores;
        private SvnCleanup operation;

        private CleanupStatusWalk() {
        }

        @Override
        public void receive(SvnTarget target, SvnStatus status) throws SVNException {
            SVNFileType kindOnDisk;
            File localAbsPath = target.getFile();
            if (status.getNodeStatus() == SVNStatusType.STATUS_EXTERNAL && this.includeExternals) {
                SVNFileType kindOnDisk2 = SVNFileType.getType(localAbsPath);
                if (kindOnDisk2 == SVNFileType.DIRECTORY) {
                    if (this.eventHandler != null) {
                        SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.CLEANUP_EXTERNAL, SVNEventAction.CLEANUP_EXTERNAL, null, null);
                        this.eventHandler.handleEvent(event, -1.0);
                    }
                    try {
                        SvnNgCleanup svnNgCleanup = new SvnNgCleanup();
                        svnNgCleanup.setOperation(this.operation);
                        svnNgCleanup.doCleanup(localAbsPath, this.wcContext, this.ignores);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                            return;
                        }
                        throw e;
                    }
                }
                return;
            }
            if (status.getNodeStatus() == SVNStatusType.STATUS_IGNORED) {
                if (!this.removeIgnoredItems) {
                    return;
                }
            } else if (status.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED) {
                if (!this.removeUnversionedItems) {
                    return;
                }
            } else {
                return;
            }
            if ((kindOnDisk = SVNFileType.getType(localAbsPath)) == SVNFileType.FILE || kindOnDisk == SVNFileType.SYMLINK) {
                SVNFileUtil.deleteFile(localAbsPath);
            } else if (kindOnDisk == SVNFileType.DIRECTORY) {
                SVNFileUtil.deleteAll(localAbsPath, true, this.eventHandler);
            } else {
                return;
            }
            if (this.eventHandler != null) {
                SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNFileType.getNodeKind(kindOnDisk), null, -1L, SVNEventAction.DELETE, SVNEventAction.DELETE, null, null);
                this.eventHandler.handleEvent(event, -1.0);
            }
        }
    }
}

