/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/GitStatisticsCollector;", "Lcom/intellij/internal/statistic/AbstractProjectsUsagesCollector;", "()V", "ID", "Lcom/intellij/internal/statistic/beans/GroupDescriptor;", "kotlin.jvm.PlatformType", "getGroupId", "getProjectUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "git4idea"})
public final class GitStatisticsCollector
extends AbstractProjectsUsagesCollector {
    private final GroupDescriptor ID = GroupDescriptor.create((String)"Git");

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        List<GitRepository> repositories = repositoryManager.getRepositories();
        HashSet<UsageDescriptor> usages = new HashSet<UsageDescriptor>();
        usages.add(new UsageDescriptor("config.repo.sync." + settings.getSyncSetting().name(), 1));
        usages.add(new UsageDescriptor("config.update.type." + settings.getUpdateType().name(), 1));
        usages.add(new UsageDescriptor("config.save.policy." + settings.updateChangesPolicy().name(), 1));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.ssh", (boolean)settings.isIdeaSsh()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.push.autoupdate", (boolean)settings.autoUpdateIfPushRejected()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.push.update.all.roots", (boolean)settings.shouldUpdateAllRootsIfPushRejected()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.cherry-pick.autocommit", (boolean)settings.isAutoCommitOnCherryPick()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.warn.about.crlf", (boolean)settings.warnAboutCrlf()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.warn.about.detached", (boolean)settings.warnAboutDetachedHead()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.force.push", (boolean)settings.warnAboutDetachedHead()));
        for (GitRepository repository : repositories) {
            GitBranchesCollection branches = repository.getBranches();
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.local.branches.count", (int)branches.getLocalBranches().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5, 8, 15, 30, 50})));
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.remote.branches.count", (int)branches.getRemoteBranches().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5, 8, 15, 30, 100})));
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.remotes.in.project", (int)repository.getRemotes().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5})));
        }
        return usages;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = this.ID;
        Intrinsics.checkExpressionValueIsNotNull((Object)groupDescriptor, (String)"ID");
        return groupDescriptor;
    }
}

