/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.TrackRenderer;

public class GradientTrackRenderer
extends JComponent
implements TrackRenderer {
    private Paint checker_paint = ColorUtil.getCheckerPaint();
    private JXMultiThumbSlider slider;

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintComponent(g);
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        Graphics2D g = (Graphics2D)gfx;
        List stops = this.slider.getModel().getSortedThumbs();
        int len = stops.size();
        float[] fractions = new float[len];
        Color[] colors = new Color[len];
        int i = 0;
        for (Thumb thumb : stops) {
            colors[i] = (Color)thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        int thumb_width = 12;
        int track_width = this.slider.getWidth() - thumb_width;
        g.translate(thumb_width / 2, 12);
        Rectangle rect = new Rectangle(0, 0, track_width, 20);
        g.setPaint(this.checker_paint);
        g.fill(rect);
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(track_width, 0.0f);
        LinearGradientPaint paint = new LinearGradientPaint((float)((Point2D)start).getX(), (float)((Point2D)start).getY(), (float)((Point2D)end).getX(), (float)((Point2D)end).getY(), fractions, colors);
        g.setPaint(paint);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        g.translate(-thumb_width / 2, -12);
    }

    @Override
    public JComponent getRendererComponent(JXMultiThumbSlider slider) {
        this.slider = slider;
        return this;
    }
}

