/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.branchConfig.CreateBranchOrTagDialog;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.update.AutoSvnUpdater;
import org.jetbrains.idea.svn.update.SingleRootSwitcher;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CreateBranchOrTagAction
extends BasicAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = SvnBundle.message("action.Subversion.Copy.text", new Object[0]);
        if (string == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(2);
        }
        return SvnStatusUtil.isUnderControl(vcs, file);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        CreateBranchOrTagDialog dialog;
        if (vcs == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(5);
        }
        if ((dialog = new CreateBranchOrTagDialog(vcs.getProject(), true, VfsUtilCore.virtualToIoFile((VirtualFile)file))).showAndGet()) {
            int rc;
            SVNURL parentUrl;
            SVNURL dstSvnUrl;
            SVNURL srcUrl;
            String dstURL = dialog.getToURL();
            SVNRevision revision = dialog.getRevision();
            String comment = dialog.getComment();
            Ref exception = new Ref();
            boolean isSrcFile = dialog.isCopyFromWorkingCopy();
            File srcFile = new File(dialog.getCopyFromPath());
            try {
                srcUrl = SVNURL.parseURIEncoded((String)dialog.getCopyFromUrl());
                dstSvnUrl = SVNURL.parseURIEncoded((String)dstURL);
                parentUrl = dstSvnUrl.removePathTail();
            }
            catch (SVNException e) {
                throw new SvnBindException(e);
            }
            if (!CreateBranchOrTagAction.dirExists(vcs, parentUrl) && (rc = Messages.showYesNoDialog((Project)vcs.getProject(), (String)("The repository path '" + parentUrl + "' does not exist. Would you like to create it?"), (String)"Branch or Tag", (Icon)Messages.getQuestionIcon())) == 1) {
                return;
            }
            Runnable copyCommand = () -> {
                if (vcs == null) {
                    CreateBranchOrTagAction.$$$reportNull$$$0(14);
                }
                try {
                    ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                    IdeaCommitHandler handler = null;
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.copy.to", dstURL));
                        handler = new IdeaCommitHandler(progress);
                    }
                    SvnTarget source = isSrcFile ? SvnTarget.fromFile((File)srcFile, (SVNRevision)revision) : SvnTarget.fromURL((SVNURL)srcUrl, (SVNRevision)revision);
                    long newRevision = vcs.getFactory(source).createCopyMoveClient().copy(source, SvnTarget.fromURL((SVNURL)dstSvnUrl), revision, true, false, comment, handler);
                    CreateBranchOrTagAction.updateStatusBar(newRevision, vcs.getProject());
                }
                catch (Exception e) {
                    exception.set((Object)e);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(copyCommand, SvnBundle.message("progress.title.copy", new Object[0]), false, vcs.getProject());
            if (!exception.isNull()) {
                throw new VcsException((Throwable)exception.get());
            }
            if (dialog.isCopyFromWorkingCopy() && dialog.isSwitchOnCreate()) {
                SingleRootSwitcher switcher = new SingleRootSwitcher(vcs.getProject(), VcsUtil.getFilePath((File)srcFile, (boolean)srcFile.isDirectory()), dstSvnUrl);
                AutoSvnUpdater.run(switcher, SvnBundle.message("action.name.switch", new Object[0]));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void updateStatusBar(long revision, @NotNull Project project) {
        void project2;
        StatusBar statusBar;
        if (project == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(6);
        }
        if (revision > 0L && (statusBar = WindowManager.getInstance().getStatusBar((Project)project2)) != null) {
            statusBar.setInfo(SvnBundle.message("status.text.comitted.revision", revision));
        }
    }

    private static boolean dirExists(@NotNull SvnVcs vcs, @NotNull SVNURL url) throws SvnBindException {
        if (vcs == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(7);
        }
        if (url == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(8);
        }
        Ref excRef = new Ref();
        Ref resultRef = new Ref((Object)Boolean.TRUE);
        Runnable taskImpl = () -> {
            if (vcs == null) {
                CreateBranchOrTagAction.$$$reportNull$$$0(12);
            }
            if (url == null) {
                CreateBranchOrTagAction.$$$reportNull$$$0(13);
            }
            try {
                vcs.getInfo(url, SVNRevision.HEAD);
            }
            catch (SvnBindException e) {
                if (e.contains(SVNErrorCode.RA_ILLEGAL_URL)) {
                    resultRef.set((Object)Boolean.FALSE);
                }
                excRef.set((Object)e);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(taskImpl, "Checking target folder", true, vcs.getProject());
        } else {
            taskImpl.run();
        }
        if (!excRef.isNull()) {
            throw (SvnBindException)((Object)excRef.get());
        }
        return (Boolean)resultRef.get();
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) {
        if (vcs == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(9);
        }
        if (files == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(10);
        }
        if (context == null) {
            CreateBranchOrTagAction.$$$reportNull$$$0(11);
        }
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagAction";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateStatusBar";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dirExists";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "batchPerform";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$dirExists$1";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$perform$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

